/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.core.registries;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class WidgetTypeDefinitionRegistry
extends SimpleContributionRegistry<WidgetTypeDefinition> {
    protected final String category;

    public WidgetTypeDefinitionRegistry(String category) {
        this.category = category;
    }

    public String getCategory() {
        return this.category;
    }

    public String getContributionId(WidgetTypeDefinition contrib) {
        return contrib.getName();
    }

    public List<WidgetTypeDefinition> getDefinitions() {
        ArrayList<WidgetTypeDefinition> res = new ArrayList<WidgetTypeDefinition>();
        for (WidgetTypeDefinition item : this.currentContribs.values()) {
            if (item == null) continue;
            res.add(item);
        }
        return res;
    }

    public WidgetTypeDefinition getDefinition(String id) {
        return (WidgetTypeDefinition)this.getCurrentContribution(id);
    }

    public synchronized void addContribution(WidgetTypeDefinition contrib) {
        super.addContribution((Object)contrib);
        List aliases = contrib.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                ContributionFragmentRegistry.FragmentList head = this.addFragment(alias, contrib);
                this.contributionUpdated(alias, head.merge((ContributionFragmentRegistry)this), contrib);
            }
        }
    }

    public synchronized void removeContribution(WidgetTypeDefinition contrib) {
        this.removeContribution(contrib, true);
    }

    public synchronized void removeContribution(WidgetTypeDefinition contrib, boolean useEqualsMethod) {
        super.removeContribution((Object)contrib, useEqualsMethod);
        List aliases = contrib.getAliases();
        if (aliases != null) {
            for (String alias : aliases) {
                ContributionFragmentRegistry.FragmentList head = this.removeFragment(alias, contrib, useEqualsMethod);
                if (head == null) continue;
                WidgetTypeDefinition result = (WidgetTypeDefinition)head.merge((ContributionFragmentRegistry)this);
                if (result != null) {
                    this.contributionUpdated(alias, result, contrib);
                    continue;
                }
                this.contributionRemoved(alias, contrib);
            }
        }
    }
}

