/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.notification;

import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.mail.Composer;
import org.nuxeo.ecm.automation.core.mail.Mailer;
import org.nuxeo.ecm.automation.core.operations.notification.MailBox;
import org.nuxeo.ecm.automation.core.operations.notification.MailTemplateHelper;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.platform.ec.notification.service.NotificationServiceHelper;
import org.nuxeo.ecm.platform.rendering.api.RenderingException;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Document.Mail", category="Notification", label="Send E-Mail", description="Send an email using the input document to the specified recipients. You can use the HTML parameter to specify whether you message is in HTML format or in plain text. Also you can attach any blob on the current document to the message by using the comma separated list of xpath expressions 'files'. If you xpath points to a blob list all blobs in the list will be attached. Return back the input document(s). If rollbackOnError is true, the whole chain will be rollbacked if an error occurs while trying to send the email (for instance if no SMTP server is configured), else a simple warning will be logged and the chain will continue.", aliases={"Notification.SendMail"})
public class SendMail {
    protected static final Log log = LogFactory.getLog(SendMail.class);
    public static final Composer COMPOSER = new Composer();
    public static final String ID = "Document.Mail";
    @Context
    protected OperationContext ctx;
    @Context
    protected UserManager umgr;
    @Param(name="from")
    protected String from;
    @Param(name="to", required=false)
    protected StringList to;
    protected Session mailSession;
    @Param(name="cc", required=false)
    protected StringList cc;
    @Param(name="bcc", required=false)
    protected StringList bcc;
    @Param(name="replyto", required=false)
    protected StringList replyto;
    @Param(name="subject")
    protected String subject;
    @Param(name="message", widget="MailTemplate")
    protected String message;
    @Param(name="HTML", required=false, values={"false"})
    protected boolean asHtml = false;
    @Param(name="files", required=false)
    protected StringList blobXpath;
    @Param(name="rollbackOnError", required=false, values={"true"})
    protected boolean rollbackOnError = true;
    @Param(name="Strict User Resolution", required=false)
    protected boolean isStrict = true;
    @Param(name="viewId", required=false, values={"view_documents"})
    protected String viewId = "view_documents";

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws TemplateException, RenderingException, OperationException, MessagingException, IOException {
        this.send(doc);
        return doc;
    }

    protected String getContent() throws OperationException, IOException {
        this.message = this.message.trim();
        if (this.message.startsWith("template:")) {
            String name = this.message.substring("template:".length()).trim();
            URL url = MailTemplateHelper.getTemplate(name);
            if (url == null) {
                throw new OperationException("No such mail template: " + name);
            }
            try (InputStream in = url.openStream();){
                String string = IOUtils.toString((InputStream)in, (Charset)Charsets.UTF_8);
                return string;
            }
        }
        return StringEscapeUtils.unescapeHtml((String)this.message);
    }

    protected void send(DocumentModel doc) throws TemplateException, RenderingException, OperationException, MessagingException, IOException {
        try {
            Map map = Scripting.initBindings((OperationContext)this.ctx);
            map.put("Document", doc);
            map.put("docUrl", this.createDocUrlWithToken(MailTemplateHelper.getDocumentUrl(doc, this.viewId), (String)map.get("token")));
            map.put("subject", this.subject);
            map.put("to", this.to);
            map.put("toResolved", MailBox.fetchPersonsFromList((List<String>)this.to, this.isStrict));
            map.put("from", this.from);
            map.put("fromResolved", MailBox.fetchPersonsFromString(this.from, this.isStrict));
            map.put("from", this.cc);
            map.put("fromResolved", MailBox.fetchPersonsFromList((List<String>)this.cc, this.isStrict));
            map.put("from", this.bcc);
            map.put("fromResolved", MailBox.fetchPersonsFromList((List<String>)this.bcc, this.isStrict));
            map.put("from", this.replyto);
            map.put("fromResolved", MailBox.fetchPersonsFromList((List<String>)this.replyto, this.isStrict));
            map.put("viewId", this.viewId);
            map.put("baseUrl", NotificationServiceHelper.getNotificationService().getServerUrlPrefix());
            map.put("Runtime", Framework.getRuntime());
            Mailer.Message msg = this.createMessage(doc, this.getContent(), map);
            msg.setSubject(this.subject, "UTF-8");
            msg.setSentDate(new Date());
            this.addMailBoxInfo(msg);
            msg.send();
        }
        catch (TemplateException | IOException | MessagingException | OperationException | NuxeoException | RenderingException e) {
            if (this.rollbackOnError) {
                throw e;
            }
            log.warn((Object)String.format("An error occured while trying to execute the %s operation, see complete stack trace below. Continuing chain since 'rollbackOnError' was set to false.", ID), e);
        }
    }

    protected String createDocUrlWithToken(String documentUrl, String token) {
        return token != null ? UriBuilder.fromUri((String)documentUrl).queryParam("token", new Object[]{token}).build(new Object[0]).toString() : documentUrl;
    }

    private void addMailBoxInfo(Mailer.Message msg) throws MessagingException {
        List<MailBox> persons = MailBox.fetchPersonsFromString(this.from, this.isStrict);
        this.addMailBoxInfoInMessageHeader(msg, Mailer.Message.AS.FROM, persons);
        persons = MailBox.fetchPersonsFromList((List<String>)this.to, this.isStrict);
        this.addMailBoxInfoInMessageHeader(msg, Mailer.Message.AS.TO, persons);
        persons = MailBox.fetchPersonsFromList((List<String>)this.cc, this.isStrict);
        this.addMailBoxInfoInMessageHeader(msg, Mailer.Message.AS.CC, persons);
        persons = MailBox.fetchPersonsFromList((List<String>)this.bcc, this.isStrict);
        this.addMailBoxInfoInMessageHeader(msg, Mailer.Message.AS.BCC, persons);
        if (this.replyto != null && !this.replyto.isEmpty()) {
            msg.setReplyTo(null);
            persons = MailBox.fetchPersonsFromList((List<String>)this.replyto, this.isStrict);
            this.addMailBoxInfoInMessageHeader(msg, Mailer.Message.AS.REPLYTO, persons);
        }
    }

    private void addMailBoxInfoInMessageHeader(Mailer.Message msg, Mailer.Message.AS as, List<MailBox> persons) throws MessagingException {
        for (MailBox person : persons) {
            msg.addInfoInMessageHeader(person.toString(), as);
        }
    }

    protected Mailer.Message createMessage(DocumentModel doc, String message, Map<String, Object> map) throws MessagingException, TemplateException, RenderingException, IOException {
        if (this.blobXpath == null) {
            if (this.asHtml) {
                return COMPOSER.newHtmlMessage(message, map);
            }
            return COMPOSER.newTextMessage(message, map);
        }
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (String xpath : this.blobXpath) {
            try {
                Property p = doc.getProperty(xpath);
                if (p instanceof BlobProperty) {
                    this.getBlob(p.getValue(), blobs);
                    continue;
                }
                if (p instanceof ListProperty) {
                    for (Property pp : p) {
                        this.getBlob(pp.getValue(), blobs);
                    }
                    continue;
                }
                if (p instanceof MapProperty) {
                    for (Property sp : ((MapProperty)p).values()) {
                        this.getBlob(sp.getValue(), blobs);
                    }
                    continue;
                }
                Serializable o = p.getValue();
                if (!(o instanceof Blob)) continue;
                blobs.add((Blob)o);
            }
            catch (PropertyException pe) {
                log.error((Object)("Error while fetching blobs: " + pe.getMessage()));
                log.debug((Object)pe, (Throwable)pe);
            }
        }
        return COMPOSER.newMixedMessage(message, map, this.asHtml ? "html" : "plain", blobs);
    }

    private void getBlob(Object o, List<Blob> blobs) {
        if (o instanceof List) {
            for (Object item : (List)o) {
                this.getBlob(item, blobs);
            }
        } else if (o instanceof Map) {
            for (Object item : ((Map)o).values()) {
                this.getBlob(item, blobs);
            }
        } else if (o instanceof Blob) {
            blobs.add((Blob)o);
        }
    }
}

