/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.features;

import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;

public class SuggestConstants {
    private static final Log log = LogFactory.getLog(SuggestConstants.class);
    public static final String LANG_TOKEN = "{lang}";
    private static final String FORCE_DISPLAY_EMAIL_IN_SUGGESTION = "nuxeo.ui.displayEmailInUserSuggestion";
    public static final String ID = "id";
    public static final String LABEL = "displayLabel";
    public static final String ICON = "icon";
    public static final String DEFAULT_LANG = "en";
    public static final String USER_TYPE = "USER_TYPE";
    public static final String GROUP_TYPE = "GROUP_TYPE";
    public static final String TYPE_KEY_NAME = "type";
    public static final String PREFIXED_ID_KEY_NAME = "prefixed_id";
    protected static Boolean forceDisplayEmailInSuggestion = null;
    public static final String DISPLAY_ICON = "displayIcon";
    public static final String PARENT_FIELD_ID = "parent";
    public static final String OBSOLETE_FIELD_ID = "obsolete";
    public static final String ABSOLUTE_LABEL = "absoluteLabel";
    public static final String COMPUTED_ID = "computedId";
    public static final String WARN_MESSAGE_LABEL = "warn_message";
    public static final String DIRECTORY_ORDER_FIELD_NAME = "ordering";
    public static final String DIRECTORY_DEFAULT_LABEL_COL_NAME = "label";
    public static final String DEFAULT_KEY_SEPARATOR = "/";

    public static void computeGroupLabel(JSONObject obj, String groupId, String groupLabelField, boolean hideFirstLabel) {
        String groupLabelValue;
        String label = null;
        label = hideFirstLabel ? groupId : (StringUtils.isNotBlank((String)(groupLabelValue = obj.optString(groupLabelField))) ? groupLabelValue : groupId);
        obj.put((Object)LABEL, (Object)label);
    }

    public static void computeUserGroupIcon(JSONObject obj, boolean hideIcon) {
        if (obj != null && !hideIcon) {
            String userGroupType = obj.optString(TYPE_KEY_NAME);
            obj.element(DISPLAY_ICON, StringUtils.isNotBlank((String)userGroupType) && (userGroupType.equals(USER_TYPE) || userGroupType.equals(GROUP_TYPE)));
        }
    }

    public static void computeUserLabel(JSONObject obj, String firstLabelField, String secondLabelField, String thirdLabelField, boolean hideFirstLabel, boolean hideSecondLabel, boolean hideThirdLabel, boolean displayEmailInSuggestion, String userId) {
        String result = "";
        if (obj != null) {
            String lastname;
            if (StringUtils.isNotBlank((String)firstLabelField) && !hideFirstLabel) {
                String firstLabel = obj.optString(firstLabelField);
                result = result + (StringUtils.isNotBlank((String)firstLabel) ? firstLabel : "");
            } else if (!hideFirstLabel) {
                String firstname = obj.optString("firstName");
                result = result + (StringUtils.isNotBlank((String)firstname) ? firstname : "");
            }
            if (StringUtils.isNotBlank((String)secondLabelField) && !hideSecondLabel) {
                String secondLabel = obj.optString(firstLabelField);
                if (StringUtils.isNotBlank((String)secondLabel)) {
                    if (StringUtils.isNotBlank((String)result)) {
                        result = result + " ";
                    }
                    result = result + secondLabel;
                }
            } else if (!hideSecondLabel && StringUtils.isNotBlank((String)(lastname = obj.optString("lastName")))) {
                if (StringUtils.isNotBlank((String)result)) {
                    result = result + " ";
                }
                result = result + lastname;
            }
            if (StringUtils.isBlank((String)result)) {
                result = result + (StringUtils.isNotBlank((String)userId) ? userId : "");
            }
            if (SuggestConstants.isForceDisplayEmailInSuggestion() || displayEmailInSuggestion && !hideThirdLabel) {
                if (StringUtils.isNotBlank((String)thirdLabelField)) {
                    String thirdLabel = obj.optString(thirdLabelField);
                    if (StringUtils.isNotBlank((String)thirdLabel)) {
                        if (StringUtils.isNotBlank((String)result)) {
                            result = result + " ";
                        }
                        result = result + thirdLabel;
                    }
                } else {
                    String email = obj.optString("email");
                    if (StringUtils.isNotBlank((String)email)) {
                        if (StringUtils.isNotBlank((String)result)) {
                            result = result + " ";
                        }
                        result = result + email;
                    }
                }
            }
            obj.put((Object)LABEL, (Object)result);
        }
    }

    public static String getLabelFieldName(Schema schema, boolean dbl10n, String labelFieldName, String lang) {
        if (labelFieldName == null || labelFieldName.isEmpty()) {
            labelFieldName = DIRECTORY_DEFAULT_LABEL_COL_NAME;
        }
        if (dbl10n) {
            int i = labelFieldName.indexOf(LANG_TOKEN);
            if (i >= 0) {
                StringBuffer buf = new StringBuffer();
                buf.append(labelFieldName.substring(0, i));
                buf.append(lang);
                buf.append(labelFieldName.substring(i + LANG_TOKEN.length()));
                String result = buf.toString();
                if (schema.getField(result) != null) {
                    return result;
                }
                buf = new StringBuffer();
                buf.append(labelFieldName.substring(0, i));
                buf.append(DEFAULT_LANG);
                buf.append(labelFieldName.substring(i + LANG_TOKEN.length()));
                return buf.toString();
            }
            String result = labelFieldName + "_" + lang;
            if (schema.getField(result) != null) {
                return result;
            }
            log.warn((Object)String.format("Unable to find field %s in directory schema %s. Trying to fallback on default one.", labelFieldName, schema.getName()));
            result = "label_en";
            if (schema.getField(result) != null) {
                return result;
            }
            result = DIRECTORY_DEFAULT_LABEL_COL_NAME;
            if (schema.getField(result) != null) {
                return result;
            }
            if (schema.getField(labelFieldName) != null) {
                return labelFieldName;
            }
            throw new IllegalArgumentException(String.format("Unable to find field %s in directory schema %s", labelFieldName, schema.getName()));
        }
        if (schema.getField(labelFieldName) != null) {
            return labelFieldName;
        }
        throw new IllegalArgumentException(String.format("Unable to find field %s in directory schema %s", labelFieldName, schema.getName()));
    }

    protected static boolean isForceDisplayEmailInSuggestion() {
        if (forceDisplayEmailInSuggestion == null) {
            ConfigurationService cs = (ConfigurationService)Framework.getService(ConfigurationService.class);
            forceDisplayEmailInSuggestion = cs.isBooleanPropertyTrue(FORCE_DISPLAY_EMAIL_IN_SUGGESTION);
        }
        return forceDisplayEmailInSuggestion;
    }

    protected SuggestConstants() {
    }
}

