/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.listener;

import java.io.Externalizable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.io.registry.MarshallerHelper;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.lib.stream.computation.Record;
import org.nuxeo.lib.stream.log.LogAppender;
import org.nuxeo.lib.stream.log.LogManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.stream.StreamService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class StreamAuditEventListener
implements EventListener,
Synchronization {
    private static final Log log = LogFactory.getLog(StreamAuditEventListener.class);
    protected static final ThreadLocal<Boolean> isEnlisted = ThreadLocal.withInitial(() -> Boolean.FALSE);
    protected static final ThreadLocal<List<LogEntry>> entries = ThreadLocal.withInitial(ArrayList::new);
    public static final String STREAM_AUDIT_ENABLED_PROP = "nuxeo.stream.audit.enabled";
    public static final String AUDIT_LOG_CONFIG_PROP = "nuxeo.stream.audit.log.config";
    public static final String DEFAULT_LOG_CONFIG = "audit";
    public static final String STREAM_NAME = "audit";

    public void handleEvent(Event event) {
        AuditLogger logger = (AuditLogger)Framework.getService(AuditLogger.class);
        if (logger == null) {
            return;
        }
        if (!isEnlisted.get().booleanValue()) {
            isEnlisted.set(this.registerSynchronization(this));
            entries.get().clear();
            if (log.isDebugEnabled()) {
                log.debug((Object)"AuditEventListener collecting entries for the tx");
            }
        }
        if (logger.getAuditableEventNames().contains(event.getName())) {
            entries.get().add(logger.buildEntryFromEvent(event));
        }
        if (!isEnlisted.get().booleanValue()) {
            this.afterCompletion(3);
        }
    }

    public void beforeCompletion() {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("AuditEventListener going to write %d entries.", entries.get().size()));
        }
    }

    public void afterCompletion(int status) {
        try {
            if (entries.get().isEmpty() || 1 == status || 4 == status) {
                return;
            }
            this.writeEntries();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("AuditEventListener writes %d entries.", entries.get().size()));
            }
        }
        finally {
            isEnlisted.set(false);
            entries.get().clear();
        }
    }

    protected void writeEntries() {
        if (entries.get().isEmpty()) {
            return;
        }
        LogAppender appender = this.getLogManager().getAppender("audit");
        entries.get().forEach(entry -> this.writeEntry((LogAppender<Record>)appender, (LogEntry)entry));
    }

    protected void writeEntry(LogAppender<Record> appender, LogEntry entry) {
        String json = this.asJson(entry);
        if (json == null) {
            return;
        }
        appender.append(0, (Externalizable)Record.of((String)String.valueOf(entry.getId()), (byte[])json.getBytes(StandardCharsets.UTF_8)));
    }

    protected String asJson(LogEntry entry) {
        if (entry == null) {
            return null;
        }
        RenderingContext ctx = RenderingContext.CtxBuilder.get();
        try {
            return MarshallerHelper.objectToJson((Object)entry, (RenderingContext)ctx);
        }
        catch (IOException e) {
            log.warn((Object)("Unable to translate entry into json, eventId:" + entry.getEventId() + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected boolean registerSynchronization(Synchronization sync) {
        try {
            TransactionManager tm = TransactionHelper.lookupTransactionManager();
            if (tm != null) {
                if (tm.getTransaction() != null) {
                    tm.getTransaction().registerSynchronization(sync);
                    return true;
                }
                return false;
            }
            log.error((Object)"Unable to register synchronization : no TransactionManager");
            return false;
        }
        catch (IllegalStateException | NamingException | RollbackException | SystemException e) {
            log.error((Object)"Unable to register synchronization", e);
            return false;
        }
    }

    protected LogManager getLogManager() {
        StreamService service = (StreamService)Framework.getService(StreamService.class);
        return service.getLogManager(this.getLogConfig());
    }

    protected String getLogConfig() {
        return Framework.getProperty((String)AUDIT_LOG_CONFIG_PROP, (String)"audit");
    }
}

