/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.reload;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.common.utils.JarUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.osgi.application.DevMutableClassLoader;
import org.nuxeo.runtime.RuntimeServiceException;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.deployment.preprocessor.DeploymentPreprocessor;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentManager;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.reload.ReloadContext;
import org.nuxeo.runtime.reload.ReloadResult;
import org.nuxeo.runtime.reload.ReloadService;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventService;
import org.nuxeo.runtime.transaction.TransactionHelper;
import org.nuxeo.runtime.util.Watch;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class ReloadComponent
extends DefaultComponent
implements ReloadService {
    public static final String RELOAD_STRATEGY_PARAMETER = "org.nuxeo.runtime.reload_strategy";
    public static final String RELOAD_STRATEGY_VALUE_UNSTASH = "unstash";
    public static final String RELOAD_STRATEGY_VALUE_STANDBY = "standby";
    public static final String RELOAD_STRATEGY_VALUE_RESTART = "restart";
    public static final String RELOAD_STRATEGY_VALUE_DEFAULT = "standby";
    private static final Log log = LogFactory.getLog(ReloadComponent.class);
    protected static Bundle bundle;
    protected Long lastFlushed;

    public static BundleContext getBundleContext() {
        return bundle.getBundleContext();
    }

    public static Bundle getBundle() {
        return bundle;
    }

    public void activate(ComponentContext context) {
        super.activate(context);
        bundle = context.getRuntimeContext().getBundle();
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        bundle = null;
    }

    @Deprecated
    protected void refreshComponents() {
        String reloadStrategy = Framework.getProperty((String)RELOAD_STRATEGY_PARAMETER, (String)"standby");
        if (log.isInfoEnabled()) {
            log.info((Object)("Refresh components. Strategy: " + reloadStrategy));
        }
        ComponentManager mgr = Framework.getRuntime().getComponentManager();
        switch (reloadStrategy) {
            case "unstash": {
                mgr.unstash();
                break;
            }
            case "standby": {
                mgr.standby();
                mgr.unstash();
                mgr.resume();
                break;
            }
            default: {
                mgr.refresh(false);
            }
        }
    }

    @Override
    public void reload() throws InterruptedException {
        log.debug((Object)"Starting reload");
        try {
            this.reloadProperties();
        }
        catch (IOException e) {
            throw new RuntimeServiceException((Throwable)e);
        }
        this.triggerReloadWithNewTransaction("reload");
    }

    @Override
    public void reloadProperties() throws IOException {
        log.info((Object)"Before reload runtime properties");
        Framework.getRuntime().reloadProperties();
        log.info((Object)"After reload runtime properties");
    }

    @Override
    public void reloadSeamComponents() {
        log.info((Object)"Reload Seam components");
        ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "reloadSeamComponents", (Object)this, null));
    }

    @Override
    public void flush() {
        log.info((Object)"Before flush caches");
        ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "flush", (Object)this, null));
        this.flushJaasCache();
        this.setFlushedNow();
        log.info((Object)"After flush caches");
    }

    @Override
    public void flushJaasCache() {
        log.info((Object)"Before flush the JAAS cache");
        ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("usermanager", "user_changed", (Object)this, (Object)"Deployer"));
        this.setFlushedNow();
        log.info((Object)"After flush the JAAS cache");
    }

    @Override
    public void flushSeamComponents() {
        log.info((Object)"Flush Seam components");
        ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "flushSeamComponents", (Object)this, null));
        this.setFlushedNow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void deployBundles(List<File> files, boolean reloadResources) throws BundleException {
        long begin = System.currentTimeMillis();
        List<String> missingNames = files.stream().filter(file -> this.getOSGIBundleName((File)file) == null).map(File::getAbsolutePath).collect(Collectors.toList());
        if (!missingNames.isEmpty()) {
            missingNames.forEach(name -> log.error((Object)String.format("No Bundle-SymbolicName found in MANIFEST for jar at '%s'", name)));
            return;
        }
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder("Before deploy bundles\n");
            Framework.getRuntime().getStatusMessage(builder);
            log.info((Object)builder.toString());
        }
        if (reloadResources) {
            List urls = files.stream().map(this::toURL).collect(Collectors.toList());
            Framework.reloadResourceLoader(urls, null);
        }
        Transaction tx = TransactionHelper.suspendTransaction();
        try {
            this._deployBundles(files);
            this.refreshComponents();
        }
        finally {
            TransactionHelper.resumeTransaction((Transaction)tx);
        }
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder("After deploy bundles.\n");
            Framework.getRuntime().getStatusMessage(builder);
            log.info((Object)builder.toString());
            log.info((Object)String.format("Hot deploy was done in %s ms.", System.currentTimeMillis() - begin));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void undeployBundles(List<String> bundleNames, boolean reloadResources) throws BundleException {
        long begin = System.currentTimeMillis();
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder("Before undeploy bundles\n");
            Framework.getRuntime().getStatusMessage(builder);
            log.info((Object)builder.toString());
        }
        Transaction tx = TransactionHelper.suspendTransaction();
        ReloadResult result = new ReloadResult();
        try {
            result.merge(this._undeployBundles(bundleNames));
            this.refreshComponents();
        }
        finally {
            TransactionHelper.resumeTransaction((Transaction)tx);
        }
        if (reloadResources) {
            List undeployedBundleURLs = result.undeployedBundles.stream().map(this::toURL).collect(Collectors.toList());
            Framework.reloadResourceLoader(null, undeployedBundleURLs);
        }
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder("After undeploy bundles.\n");
            Framework.getRuntime().getStatusMessage(builder);
            log.info((Object)builder.toString());
            log.info((Object)String.format("Hot undeploy was done in %s ms.", System.currentTimeMillis() - begin));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReloadResult reloadBundles(ReloadContext context) throws BundleException {
        ReloadResult result = new ReloadResult();
        List<String> bundlesNamesToUndeploy = context.bundlesNamesToUndeploy;
        Watch watch = new Watch(new LinkedHashMap()).start();
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder("Before updating Nuxeo server\n");
            Framework.getRuntime().getStatusMessage(builder);
            log.info((Object)builder.toString());
        }
        Optional<DevMutableClassLoader> classLoader = Optional.of(this.getClass().getClassLoader()).filter(DevMutableClassLoader.class::isInstance).map(DevMutableClassLoader.class::cast);
        watch.start("flush");
        this.flush();
        watch.stop("flush");
        Transaction tx = TransactionHelper.suspendTransaction();
        try {
            ComponentManager componentManager = Framework.getRuntime().getComponentManager();
            String reloadStrategy = Framework.getProperty((String)RELOAD_STRATEGY_PARAMETER, (String)"standby");
            if (log.isInfoEnabled()) {
                log.info((Object)("Component reload strategy=" + reloadStrategy));
            }
            watch.start("stop/standby");
            log.info((Object)"Before stop/standby component manager");
            if (RELOAD_STRATEGY_VALUE_RESTART.equals(reloadStrategy)) {
                componentManager.stop();
            } else {
                componentManager.standby();
            }
            log.info((Object)"After stop/standby component manager");
            watch.stop("stop/standby");
            if (!bundlesNamesToUndeploy.isEmpty()) {
                watch.start("undeploy-bundles");
                log.info((Object)"Before undeploy bundles");
                this.logComponentManagerStatus();
                result.merge(this._undeployBundles(bundlesNamesToUndeploy));
                componentManager.unstash();
                classLoader.ifPresent(DevMutableClassLoader::clearPreviousClassLoader);
                log.info((Object)"After undeploy bundles");
                this.logComponentManagerStatus();
                watch.stop("undeploy-bundles");
            }
            watch.start("delete-copy");
            log.info((Object)"Before delete-copy");
            List urlsToRemove = result.undeployedBundles.stream().map(Bundle::getLocation).map(File::new).peek(File::delete).map(this::toURL).collect(Collectors.toList());
            List<File> bundlesToDeploy = this.copyBundlesToDeploy(context);
            List urlsToAdd = bundlesToDeploy.stream().map(this::toURL).collect(Collectors.toList());
            log.info((Object)"After delete-copy");
            watch.stop("delete-copy");
            watch.start("reload-resources");
            Framework.reloadResourceLoader(urlsToAdd, urlsToRemove);
            watch.stop("reload-resources");
            if (!bundlesToDeploy.isEmpty()) {
                watch.start("deploy-bundles");
                log.info((Object)"Before deploy bundles");
                this.logComponentManagerStatus();
                classLoader.ifPresent(cl -> cl.addClassLoader(urlsToAdd.toArray(new URL[0])));
                result.merge(this._deployBundles(bundlesToDeploy));
                componentManager.unstash();
                log.info((Object)"After deploy bundles");
                this.logComponentManagerStatus();
                watch.stop("deploy-bundles");
            }
            watch.start("start/resume");
            log.info((Object)"Before start/resume component manager");
            if (RELOAD_STRATEGY_VALUE_RESTART.equals(reloadStrategy)) {
                componentManager.start();
            } else {
                componentManager.resume();
            }
            log.info((Object)"After start/resume component manager");
            watch.stop("start/resume");
            try {
                watch.start("deployment-preprocessor");
                this.runDeploymentPreprocessor();
                watch.stop("deployment-preprocessor");
            }
            catch (IOException e) {
                throw new BundleException("Unable to run deployment preprocessor", (Throwable)e);
            }
            try {
                watch.start("reload-properties");
                this.reloadProperties();
                watch.stop("reload-properties");
            }
            catch (IOException e) {
                throw new BundleException("Unable to reload properties", (Throwable)e);
            }
        }
        finally {
            TransactionHelper.resumeTransaction((Transaction)tx);
        }
        if (log.isInfoEnabled()) {
            StringBuilder builder = new StringBuilder("After updating Nuxeo server\n");
            Framework.getRuntime().getStatusMessage(builder);
            log.info((Object)builder.toString());
        }
        watch.stop();
        if (log.isInfoEnabled()) {
            StringBuilder message = new StringBuilder();
            message.append("Hot reload was done in ").append(watch.getTotal().elapsed(TimeUnit.MILLISECONDS)).append(" ms, detailed steps:");
            Stream.of(watch.getIntervals()).forEach(i -> message.append("\n- ").append(i.getName()).append(": ").append(i.elapsed(TimeUnit.MILLISECONDS)).append(" ms"));
            log.info((Object)message.toString());
        }
        return result;
    }

    protected List<File> copyBundlesToDeploy(ReloadContext context) throws BundleException {
        ArrayList<File> bundlesToDeploy = new ArrayList<File>();
        Path homePath = Framework.getRuntime().getHome().toPath();
        Path destinationPath = homePath.resolve(context.bundlesDestination);
        try {
            Files.createDirectories(destinationPath, new FileAttribute[0]);
            for (File bundle : context.bundlesToDeploy) {
                Path bundlePath = bundle.toPath();
                if (!bundlePath.startsWith(destinationPath)) {
                    if (Files.isDirectory(bundlePath, new LinkOption[0])) {
                        bundlePath = JarUtils.zipDirectory((Path)bundlePath, (Path)destinationPath.resolve("hotreload-bundle-" + System.currentTimeMillis() + ".jar"), (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
                    } else {
                        bundlePath = destinationPath.resolve(bundle.getName());
                        org.apache.commons.io.FileUtils.copyFile((File)bundle, (File)bundlePath.toFile(), (boolean)false);
                    }
                }
                bundlesToDeploy.add(bundlePath.toFile());
            }
            return bundlesToDeploy;
        }
        catch (IOException e) {
            throw new BundleException("Unable to copy bundles to " + destinationPath, (Throwable)e);
        }
    }

    protected ReloadResult _deployBundles(List<File> bundlesToDeploy) throws BundleException {
        ReloadResult result = new ReloadResult();
        BundleContext bundleContext = ReloadComponent.getBundleContext();
        for (File file : bundlesToDeploy) {
            Bundle bundle;
            String path = file.getAbsolutePath();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Before deploy bundle for file at '%s'", path));
            }
            if ((bundle = bundleContext.installBundle(path)) == null) {
                throw new IllegalArgumentException("Could not find a valid bundle at path: " + path);
            }
            bundle.start();
            result.deployedBundles.add(bundle);
            if (!log.isInfoEnabled()) continue;
            log.info((Object)String.format("Deploy done for bundle with name '%s'", bundle.getSymbolicName()));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReloadResult _undeployBundles(List<String> bundleNames) throws BundleException {
        ReloadResult result = new ReloadResult();
        BundleContext ctx = ReloadComponent.getBundleContext();
        ServiceReference ref = ctx.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin srv = (PackageAdmin)ctx.getService(ref);
        try {
            for (String bundleName : bundleNames) {
                for (Bundle bundle : srv.getBundles(bundleName, null)) {
                    if (bundle == null || bundle.getState() != 32) continue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Before undeploy bundle with name '%s'.", bundleName));
                    }
                    bundle.stop();
                    bundle.uninstall();
                    result.undeployedBundles.add(bundle);
                    if (!log.isInfoEnabled()) continue;
                    log.info((Object)String.format("After undeploy bundle with name '%s'.", bundleName));
                }
            }
        }
        finally {
            ctx.ungetService(ref);
        }
        return result;
    }

    protected URL toURL(Bundle bundle) {
        String location = bundle.getLocation();
        File file = new File(location);
        return this.toURL(file);
    }

    protected URL toURL(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeServiceException((Throwable)e);
        }
    }

    protected void logComponentManagerStatus() {
        if (log.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("ComponentManager status:\n");
            Framework.getRuntime().getStatusMessage(builder);
            log.debug((Object)builder.toString());
        }
    }

    @Override
    public Long lastFlushed() {
        return this.lastFlushed;
    }

    protected void setFlushedNow() {
        this.lastFlushed = System.currentTimeMillis();
    }

    @Override
    @Deprecated
    public void installWebResources(File file) throws IOException {
        log.info((Object)"Install web resources");
        if (file.isDirectory()) {
            File war = new File(file, "web");
            if ((war = new File(war, "nuxeo.war")).isDirectory()) {
                FileUtils.copyTree((File)war, (File)ReloadComponent.getAppDir());
            } else {
                war = new File(file, "nuxeo.war");
                if (war.isDirectory()) {
                    FileUtils.copyTree((File)war, (File)ReloadComponent.getAppDir());
                }
            }
        } else if (file.isFile()) {
            File war = ReloadComponent.getWarDir();
            ZipUtils.unzip((String)"web/nuxeo.war", (File)file, (File)war);
            ZipUtils.unzip((String)"nuxeo.war", (File)file, (File)war);
        }
    }

    @Override
    public void runDeploymentPreprocessor() throws IOException {
        log.info((Object)"Start running deployment preprocessor");
        String rootPath = Environment.getDefault().getRuntimeHome().getAbsolutePath();
        File root = new File(rootPath);
        DeploymentPreprocessor processor = new DeploymentPreprocessor(root);
        processor.init();
        processor.predeploy();
        log.info((Object)"Deployment preprocessing done");
    }

    protected static File getAppDir() {
        return Environment.getDefault().getConfig().getParentFile();
    }

    protected static File getWarDir() {
        return new File(ReloadComponent.getAppDir(), "nuxeo.war");
    }

    @Override
    public String getOSGIBundleName(File file) {
        Manifest mf = JarUtils.getManifest((File)file);
        if (mf == null) {
            return null;
        }
        String bundleName = mf.getMainAttributes().getValue("Bundle-SymbolicName");
        if (bundleName == null) {
            return null;
        }
        int index = bundleName.indexOf(59);
        if (index > -1) {
            bundleName = bundleName.substring(0, index);
        }
        return bundleName;
    }

    @Deprecated
    protected void triggerReloadWithNewTransaction(String eventId) throws InterruptedException {
        if (TransactionHelper.isTransactionMarkedRollback()) {
            throw new AssertionError((Object)"The calling transaction is marked rollback");
        }
        boolean hasTransaction = TransactionHelper.isTransactionActiveOrMarkedRollback();
        if (hasTransaction) {
            TransactionHelper.commitOrRollbackTransaction();
        }
        try {
            TransactionHelper.runInTransaction(() -> this.triggerReload(eventId));
        }
        finally {
            if (hasTransaction) {
                TransactionHelper.startTransaction();
            }
        }
    }

    @Deprecated
    protected void triggerReload(String eventId) {
        log.info((Object)("About to send reload event for id: " + eventId));
        ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "before-reload", (Object)this, null));
        try {
            ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", eventId, (Object)this, null));
        }
        finally {
            ((EventService)Framework.getService(EventService.class)).sendEvent(new Event("org.nuxeo.runtime.reload", "after-reload", (Object)this, null));
            log.info((Object)("Returning from reload for event id: " + eventId));
        }
    }
}

