/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.nio.file.Path;
import java.util.concurrent.TimeUnit;
import java.util.function.IntSupplier;
import java.util.function.ToIntFunction;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.DirectoryListing;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TableDirectoryListing
implements DirectoryListing {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableDirectoryListing.class);
    private static final long LOCK_ACQUISITION_TIMEOUT_MILLIS = Long.getLong("chronicle.listing.lock.timeout", TimeUnit.SECONDS.toMillis(20L));
    private static final long LOCK_MAX_AGE_MILLIS = Long.getLong("chronicle.listing.lock.maxAge", TimeUnit.SECONDS.toMillis(10L));
    private static final String HIGHEST_CREATED_CYCLE = "listing.highestCycle";
    private static final String LOWEST_CREATED_CYCLE = "listing.lowestCycle";
    static final String LOCK = "listing.exclusiveLock";
    private static final String MOD_COUNT = "listing.modCount";
    private static final int UNSET_MAX_CYCLE = Integer.MIN_VALUE;
    private static final int UNSET_MIN_CYCLE = Integer.MAX_VALUE;
    private final TableStore tableStore;
    private final Path queuePath;
    private final ToIntFunction<File> fileToCycleFunction;
    private final IntSupplier getMaxCycleValueMethodRef = this::getMaxCycleValue;
    private final IntSupplier getMinCycleValueMethodRef = this::getMinCycleValue;
    private final IntSupplier refreshIndexMethodRef = this::refreshIndex;
    private volatile LongValue maxCycleValue;
    private volatile LongValue minCycleValue;
    private volatile LongValue lock;
    private volatile LongValue modCount;
    private final boolean readOnly;

    TableDirectoryListing(TableStore tableStore, Path queuePath, ToIntFunction<File> fileToCycleFunction, boolean readOnly) {
        this.tableStore = tableStore;
        this.queuePath = queuePath;
        this.fileToCycleFunction = fileToCycleFunction;
        this.readOnly = readOnly;
    }

    @Override
    public void init() {
        this.tableStore.doWithExclusiveLock(ts -> {
            this.maxCycleValue = ts.acquireValueFor(HIGHEST_CREATED_CYCLE);
            this.minCycleValue = ts.acquireValueFor(LOWEST_CREATED_CYCLE);
            this.lock = ts.acquireValueFor(LOCK);
            this.modCount = ts.acquireValueFor(MOD_COUNT);
            if (this.lock.getVolatileValue() == Long.MIN_VALUE) {
                this.lock.compareAndSwapValue(Long.MIN_VALUE, 0L);
            }
            if (this.modCount.getVolatileValue() == Long.MIN_VALUE) {
                this.modCount.compareAndSwapValue(Long.MIN_VALUE, 0L);
            }
            return this;
        });
    }

    @Override
    public void refresh() {
        if (this.readOnly) {
            return;
        }
        this.tryWithLock(this.refreshIndexMethodRef);
    }

    @Override
    public void onFileCreated(File file, int cycle) {
        if (this.readOnly) {
            LOGGER.warn("DirectoryListing is read-only, not updating listing");
            return;
        }
        this.modCount.addAtomicValue(1L);
        this.tryWithLock(() -> {
            this.maxCycleValue.setMaxValue(cycle);
            this.minCycleValue.setMinValue(cycle);
            return 0;
        });
    }

    @Override
    public int getMaxCreatedCycle() {
        int maxCycleValue = this.getMaxCycleValue();
        if (this.readOnly) {
            return maxCycleValue;
        }
        if (maxCycleValue != Integer.MIN_VALUE) {
            return maxCycleValue;
        }
        return this.tryWithLock(this.getMaxCycleValueMethodRef);
    }

    @Override
    public int getMinCreatedCycle() {
        int minCycleValue = this.getMinCycleValue();
        if (this.readOnly) {
            return minCycleValue;
        }
        if (minCycleValue != Integer.MAX_VALUE) {
            return minCycleValue;
        }
        return this.tryWithLock(this.getMinCycleValueMethodRef);
    }

    @Override
    public long modCount() {
        return this.modCount.getVolatileValue();
    }

    public String toString() {
        return this.tableStore.dump();
    }

    private int getMaxCycleValue() {
        return (int)this.maxCycleValue.getVolatileValue();
    }

    private int getMinCycleValue() {
        return (int)this.minCycleValue.getVolatileValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int tryWithLock(IntSupplier function) {
        long currentTime;
        long lockAcquisitionTimeout = System.currentTimeMillis() + LOCK_ACQUISITION_TIMEOUT_MILLIS;
        while ((currentTime = System.currentTimeMillis()) < lockAcquisitionTimeout) {
            if (this.lock.compareAndSwapValue(0L, currentTime)) {
                try {
                    int n = function.getAsInt();
                    return n;
                }
                finally {
                    if (!this.lock.compareAndSwapValue(currentTime, 0L)) {
                        throw new IllegalStateException("Unable to reset lock state");
                    }
                }
            }
            long lastLockTime = this.lock.getValue();
            if (lastLockTime != 0L && lastLockTime < currentTime - LOCK_MAX_AGE_MILLIS && this.lock.compareAndSwapValue(lastLockTime, currentTime)) {
                LOGGER.warn("Forcing lock on directory listing as it is {}sec old", (Object)((currentTime - lastLockTime) / 1000L));
                try {
                    int n = function.getAsInt();
                    return n;
                }
                finally {
                    if (!this.lock.compareAndSwapValue(currentTime, 0L)) {
                        throw new IllegalStateException("Unable to reset lock state");
                    }
                }
            }
            Thread.yield();
        }
        throw new IllegalStateException("Unable to acquire exclusive lock on directory listing.\nConsider changing system properties chronicle.listing.lock.timeout/chronicle.listing.lock.maxAge");
    }

    private int refreshIndex() {
        this.maxCycleValue.setOrderedValue(Integer.MIN_VALUE);
        this.minCycleValue.setOrderedValue(Integer.MAX_VALUE);
        File[] queueFiles = this.queuePath.toFile().listFiles((d, f) -> f.endsWith(".cq4"));
        if (queueFiles != null) {
            for (File queueFile : queueFiles) {
                this.maxCycleValue.setMaxValue(this.fileToCycleFunction.applyAsInt(queueFile));
                this.minCycleValue.setMinValue(this.fileToCycleFunction.applyAsInt(queueFile));
            }
        }
        return 0;
    }

    void close() {
        this.tableStore.close();
    }
}

