/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb.tools;

import org.sat4j.core.Vec;
import org.sat4j.core.VecInt;
import org.sat4j.pb.tools.DependencyHelper;
import org.sat4j.pb.tools.ImplicationNamer;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IVec;
import org.sat4j.specs.IVecInt;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisjunctionRHS<T, C> {
    private final IVecInt literals;
    private final DependencyHelper<T, C> helper;
    private final IVec<IConstr> toName = new Vec();

    public DisjunctionRHS(DependencyHelper<T, C> helper, IVecInt literals) {
        this.literals = literals;
        this.helper = helper;
    }

    public ImplicationNamer<T, C> implies(T[] things) throws ContradictionException {
        VecInt clause = new VecInt();
        T[] TArray = things;
        int n = things.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            clause.push(this.helper.getIntValue(t));
            ++n2;
        }
        for (int p : this.literals) {
            clause.push(p);
            IConstr constr = this.helper.solver.addClause((IVecInt)clause);
            if (constr == null) {
                throw new IllegalStateException("Constraints are not supposed to be null when using the helper");
            }
            this.toName.push((Object)constr);
            clause.remove(p);
        }
        return new ImplicationNamer<T, C>(this.helper, this.toName);
    }
}

