/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.plugins;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.DocumentModelImpl;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.ImportExtension;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;

public class ExtensibleDocumentWriter
extends DocumentModelWriter {
    protected static Log log = LogFactory.getLog(ExtensibleDocumentWriter.class);
    protected List<ImportExtension> extensions = new ArrayList<ImportExtension>();

    public ExtensibleDocumentWriter(CoreSession session, String parentPath) {
        super(session, parentPath);
    }

    public void registerExtension(ImportExtension ext) {
        this.extensions.add(ext);
    }

    @Override
    protected DocumentModel createDocument(ExportedDocument xdoc, Path toPath) {
        Element version;
        String uuid;
        Path parentPath = toPath.removeLastSegments(1);
        String name = toPath.lastSegment();
        DocumentModel doc = this.session.createDocumentModel(parentPath.toString(), name, xdoc.getType());
        Element system = xdoc.getDocument().getRootElement().element("system");
        String lifeCycleState = system.element("lifecycle-state").getText();
        String lifeCyclePolicy = system.element("lifecycle-policy").getText();
        doc.putContextData("ecm:lifeCyclePolicy", (Serializable)((Object)lifeCyclePolicy));
        doc.putContextData("ecm:lifeCycleState", (Serializable)((Object)lifeCycleState));
        this.loadFacetsInfo(doc, xdoc.getDocument());
        this.loadSchemas(xdoc, doc, xdoc.getDocument());
        if (doc.hasSchema("uid")) {
            doc.putContextData("SKIP_VERSIONING", (Serializable)Boolean.valueOf(true));
        }
        if ((uuid = xdoc.getId()) != null) {
            ((DocumentModelImpl)doc).setId(uuid);
        }
        if ((version = xdoc.getDocument().getRootElement().element("version")) != null) {
            Element e = version.element("isVersion");
            String isVersion = version.elementText("isVersion");
            if ("true".equals(isVersion)) {
                String label = version.elementText("ecm:versionLabel".substring(4));
                String sourceId = version.elementText("ecm:versionableId".substring(4));
                String desc = version.elementText("ecm:versionDescription".substring(4));
                String created = version.elementText("ecm:versionCreated".substring(4));
                if (label != null) {
                    doc.putContextData("ecm:versionLabel", (Serializable)((Object)label));
                }
                if (sourceId != null) {
                    doc.putContextData("ecm:versionableId", (Serializable)((Object)sourceId));
                }
                if (desc != null) {
                    doc.putContextData("ecm:versionDescription", (Serializable)((Object)desc));
                }
                if (created != null) {
                    doc.putContextData("ecm:versionCreated", (Serializable)new DateType().decode(created));
                }
                doc.setPathInfo(null, name);
                ((DocumentModelImpl)doc).setIsVersion(true);
                doc.putContextData("ecm:majorVersion", doc.getPropertyValue("uid:major_version"));
                doc.putContextData("ecm:minorVersion", doc.getPropertyValue("uid:minor_version"));
                doc.putContextData("ecm:isVersion", (Serializable)Boolean.valueOf(true));
            }
        }
        if (doc.getId() != null) {
            this.session.importDocuments(Collections.singletonList(doc));
        } else {
            doc = this.session.createDocument(doc);
        }
        this.loadSystemInfo(doc, xdoc.getDocument());
        for (ImportExtension ext : this.extensions) {
            try {
                ext.updateImport(this.session, doc, xdoc);
            }
            catch (Exception e) {
                log.error((Object)"Error while processing extensions", (Throwable)e);
                throw new NuxeoException((Throwable)e);
            }
        }
        ++this.unsavedDocuments;
        this.saveIfNeeded();
        return doc;
    }
}

