/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.enrichers;

import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.query.sql.NXQL;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class HasFolderishChildJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "hasFolderishChild";

    public HasFolderishChildJsonEnricher() {
        super(NAME);
    }

    @Override
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        if (!document.isFolder()) {
            jg.writeBooleanField(NAME, false);
            return;
        }
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            String fetchFolderishChildQuery = "SELECT * FROM Document WHERE ecm:mixinType = 'Folderish' AND ecm:mixinType != 'HiddenInNavigation' AND ecm:currentLifeCycleState != 'deleted' AND ecm:parentId = " + NXQL.escapeString((String)document.getId());
            DocumentModelList children = wrapper.getSession().query(fetchFolderishChildQuery, 1);
            jg.writeBooleanField(NAME, !children.isEmpty());
        }
    }
}

