/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.localconfiguration;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfiguration;
import org.nuxeo.ecm.core.api.localconfiguration.LocalConfigurationService;
import org.nuxeo.runtime.model.DefaultComponent;

public class LocalConfigurationServiceImpl
extends DefaultComponent
implements LocalConfigurationService {
    private static final Log log = LogFactory.getLog(LocalConfigurationServiceImpl.class);

    @Override
    public <T extends LocalConfiguration> T getConfiguration(Class<T> configurationClass, String configurationFacet, DocumentModel currentDoc) {
        LocalConfiguration parentConfiguration;
        DocumentModel parentDoc;
        DocumentRef parentRef;
        if (currentDoc == null || currentDoc.getRef() == null) {
            return null;
        }
        CoreSession session = currentDoc.getCoreSession();
        if (session == null) {
            return null;
        }
        LocalConfiguration localConfiguration = (LocalConfiguration)session.adaptFirstMatchingDocumentWithFacet(currentDoc.getRef(), configurationFacet, configurationClass);
        if (localConfiguration == null) {
            return null;
        }
        while (localConfiguration.canMerge() && ((parentRef = session.getParentDocumentRef(localConfiguration.getDocumentRef())) != null || (parentDoc = session.getParentDocument(localConfiguration.getDocumentRef())) != null && (parentRef = parentDoc.getRef()) != null) && (parentConfiguration = (LocalConfiguration)session.adaptFirstMatchingDocumentWithFacet(parentRef, configurationFacet, configurationClass)) != null) {
            localConfiguration.merge(parentConfiguration);
        }
        return (T)localConfiguration;
    }
}

