/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.api.model.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.api.model.PropertyVisitor;
import org.nuxeo.ecm.core.api.model.impl.AbstractProperty;
import org.nuxeo.ecm.core.schema.types.ComplexType;
import org.nuxeo.ecm.core.schema.types.ComplexTypeImpl;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.Type;

public class RemovedProperty
extends AbstractProperty {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(RemovedProperty.class);
    protected final String fieldName;
    protected final Property fallback;

    public RemovedProperty(Property parent, String fieldName) {
        this(parent, fieldName, null);
    }

    public RemovedProperty(Property parent, String fieldName, Property fallback) {
        super(parent);
        this.fieldName = fieldName;
        this.fallback = fallback;
    }

    @Override
    public void internalSetValue(Serializable value) throws PropertyException {
        StringBuilder msg = this.newRemovedMessage();
        if (this.fallback == null) {
            msg.append("Do nothing");
        } else {
            msg.append("Set value to fallback property '").append(this.fallback.getXPath()).append("'");
        }
        if (log.isTraceEnabled()) {
            log.error((Object)msg, (Throwable)new NuxeoException("debug stack trace"));
        } else {
            log.error((Object)msg);
        }
        if (this.fallback != null) {
            this.fallback.setValue(value);
        }
    }

    @Override
    public Serializable internalGetValue() throws PropertyException {
        StringBuilder msg = this.newRemovedMessage();
        if (this.fallback == null) {
            msg.append("Return null");
        } else {
            msg.append("Return value from '").append(this.fallback.getXPath()).append("'");
        }
        if (log.isTraceEnabled()) {
            log.error((Object)msg, (Throwable)new NuxeoException());
        } else {
            log.error((Object)msg);
        }
        if (this.fallback == null) {
            return null;
        }
        return this.fallback.getValue();
    }

    protected StringBuilder newRemovedMessage() {
        StringBuilder builder = new StringBuilder().append("Property '").append(this.getXPath()).append("' is marked as removed from '").append(this.getSchema().getName()).append("' schema");
        RemovedProperty removedParent = this.getRemovedParent();
        if (removedParent != this) {
            builder.append(" because property '").append(removedParent.getXPath()).append("' is marked as removed");
        }
        return builder.append(", don't use it anymore. ");
    }

    protected RemovedProperty getRemovedParent() {
        RemovedProperty property = this;
        while (property.getParent() instanceof RemovedProperty) {
            property = (RemovedProperty)property.getParent();
        }
        return property;
    }

    @Override
    public String getName() {
        return this.fieldName;
    }

    @Override
    public Type getType() {
        if (this.fallback == null) {
            return new ComplexTypeImpl((ComplexType)this.getSchema(), this.getSchema().getName(), this.fieldName);
        }
        return this.fallback.getType();
    }

    @Override
    public boolean isContainer() {
        return this.fallback == null || this.fallback.isContainer();
    }

    @Override
    public Collection<Property> getChildren() {
        return Collections.emptyList();
    }

    @Override
    public Property get(String name) throws PropertyNotFoundException {
        if (this.fallback != null) {
            return new RemovedProperty(this, name, this.fallback.get(name));
        }
        if (name.matches("\\d+")) {
            return this.get(Integer.parseInt(name));
        }
        return new RemovedProperty((Property)this, name);
    }

    @Override
    public Property get(int index) throws PropertyNotFoundException {
        return new RemovedProperty((Property)this, this.fieldName);
    }

    @Override
    public Property addValue(Object value) throws PropertyException {
        throw new UnsupportedOperationException("Removed properties don't have children");
    }

    @Override
    public Property addValue(int index, Object value) throws PropertyException {
        throw new UnsupportedOperationException("Removed properties don't have children");
    }

    @Override
    public Property addEmpty() throws PropertyException {
        throw new UnsupportedOperationException("Removed properties don't have children");
    }

    @Override
    public Field getField() {
        throw new UnsupportedOperationException("Removed properties don't have field");
    }

    @Override
    public void accept(PropertyVisitor visitor, Object arg) throws PropertyException {
    }

    @Override
    public boolean isSameAs(Property property) throws PropertyException {
        if (!(property instanceof RemovedProperty)) {
            return false;
        }
        RemovedProperty rp = (RemovedProperty)property;
        return Objects.equals(this.getSchema(), rp.getSchema()) && Objects.equals(this.getName(), this.getName()) && Objects.equals(this.getRemovedParent().getName(), rp.getRemovedParent().getName());
    }

    @Override
    public Iterator<Property> getDirtyChildren() {
        return Collections.emptyIterator();
    }
}

