/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.notification.io;

import java.io.IOException;
import java.util.List;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.ec.notification.SubscriptionAdapter;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class NotificationsJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "subscribedNotifications";

    public NotificationsJsonEnricher() {
        super(NAME);
    }

    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        jg.writeFieldName(NAME);
        jg.writeStartArray();
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            String username = "user:" + wrapper.getSession().getPrincipal().getName();
            List<String> notifications = ((SubscriptionAdapter)document.getAdapter(SubscriptionAdapter.class)).getUserSubscriptions(username);
            for (String notification : notifications) {
                jg.writeString(notification);
            }
        }
        jg.writeEndArray();
    }
}

