/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.commandline.executor.service.cmdtesters;

import java.io.IOException;
import java.io.InputStream;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.ecm.platform.commandline.executor.service.CommandLineDescriptor;
import org.nuxeo.ecm.platform.commandline.executor.service.cmdtesters.CommandTestResult;
import org.nuxeo.ecm.platform.commandline.executor.service.cmdtesters.CommandTester;

public class DefaultCommandTester
implements CommandTester {
    @Override
    public CommandTestResult test(CommandLineDescriptor cmdDescriptor) {
        String cmd = cmdDescriptor.getCommand();
        String params = cmdDescriptor.getTestParametersString();
        String[] cmdWithParams = (cmd + " " + params).split(" ");
        try {
            ProcessBuilder builder = new ProcessBuilder(cmdWithParams);
            builder.redirectErrorStream(true);
            Process process = builder.start();
            process.getOutputStream().close();
            try (InputStream in = process.getInputStream();){
                byte[] bytes = new byte[4096];
                while (in.read(bytes) != -1) {
                }
            }
            process.waitFor();
        }
        catch (InterruptedException e) {
            ExceptionUtils.checkInterrupt((Exception)e);
        }
        catch (IOException e) {
            return new CommandTestResult("command " + cmd + " not found in system path (descriptor " + cmdDescriptor + ")");
        }
        return new CommandTestResult();
    }
}

