/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.data;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.restlet.Application;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.resource.DomRepresentation;
import org.restlet.resource.Representation;
import org.restlet.resource.SaxRepresentation;
import org.restlet.resource.StringRepresentation;
import org.restlet.service.ConverterService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Message {
    private Map<String, Object> attributes = null;
    private Representation entity;

    public Message() {
        this(null);
    }

    public Message(Representation entity) {
        this.entity = entity;
    }

    public Map<String, Object> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new TreeMap<String, Object>();
        }
        return this.attributes;
    }

    private ConverterService getConverterService() {
        ConverterService result = null;
        Application application = (Application)this.getAttributes().get("org.restlet.application");
        result = application != null ? application.getConverterService() : new ConverterService();
        return result;
    }

    public Representation getEntity() {
        return this.entity;
    }

    public DomRepresentation getEntityAsDom() {
        return new DomRepresentation(this.getEntity());
    }

    public Form getEntityAsForm() {
        return new Form(this.getEntity());
    }

    public Object getEntityAsObject() {
        return this.getConverterService().toObject(this.getEntity());
    }

    public SaxRepresentation getEntityAsSax() {
        try {
            return new SaxRepresentation(this.getEntity());
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isEntityAvailable() {
        return this.getEntity() != null && this.getEntity().getSize() != 0L && this.getEntity().isAvailable();
    }

    public void setEntity(Object object) {
        if (object instanceof Representation) {
            this.setEntity((Representation)object);
        } else {
            this.setEntity(this.getConverterService().toRepresentation(object));
        }
    }

    public void setEntity(Representation entity) {
        this.entity = entity;
    }

    public void setEntity(String value, MediaType mediaType) {
        this.setEntity(new StringRepresentation((CharSequence)value, mediaType));
    }
}

