/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api.login;

import java.io.IOException;
import java.security.Principal;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.api.login.CredentialsCallback;
import org.nuxeo.runtime.api.login.LoginComponent;
import org.nuxeo.runtime.api.login.LoginService;

public class SystemLoginModule
implements LoginModule {
    private static final Log log = LogFactory.getLog(SystemLoginModule.class);
    protected Subject subject;
    protected CallbackHandler callbackHandler;
    protected Map<String, Object> sharedState = new HashMap<String, Object>();
    protected boolean trace;

    @Override
    public void initialize(Subject subject, CallbackHandler callbackHandler, Map<String, ?> sharedState, Map<String, ?> options) {
        this.subject = subject;
        this.sharedState.putAll(sharedState);
        this.callbackHandler = callbackHandler;
        this.trace = log.isTraceEnabled();
    }

    @Override
    public boolean login() throws LoginException {
        LoginService loginService;
        if (this.trace) {
            log.trace((Object)"begin system login");
        }
        if ((loginService = Framework.getService(LoginService.class)) == null) {
            throw new LoginException("Nuxeo Login Service is not running - cannot do system login");
        }
        CredentialsCallback cb = new CredentialsCallback();
        try {
            this.callbackHandler.handle(new Callback[]{cb});
        }
        catch (IOException | RuntimeException | UnsupportedCallbackException e) {
            LoginException ee = new LoginException("System login failed - callback failed");
            ee.initCause(e);
            throw ee;
        }
        Object credential = cb.getCredentials();
        if (LoginComponent.isSystemLogin(credential)) {
            Principal principal = (Principal)credential;
            this.sharedState.put("javax.security.auth.login.name", principal);
            this.sharedState.put("javax.security.auth.login.password", null);
            if (this.trace) {
                log.trace((Object)"System Login Succeded");
            }
            return true;
        }
        if (this.trace) {
            log.trace((Object)"System Login Failed");
        }
        return false;
    }

    @Override
    public boolean commit() throws LoginException {
        if (this.trace) {
            log.trace((Object)("commit, subject=" + this.subject));
        }
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (this.trace) {
            log.trace((Object)("abort, subject=" + this.subject));
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        if (this.trace) {
            log.trace((Object)("logout, subject=" + this.subject));
        }
        return true;
    }
}

