/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.exceptionhandling.service;

import java.io.IOException;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoExceptionHandler;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.NuxeoExceptionHandlerParameters;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.descriptor.ErrorHandlersDescriptor;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.descriptor.ExceptionHandlerDescriptor;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.descriptor.ListenerDescriptor;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.descriptor.RequestDumpDescriptor;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.service.ExceptionHandlingService;
import org.nuxeo.ecm.platform.web.common.exceptionhandling.service.RequestDumper;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ExceptionHandlingComponent
extends DefaultComponent
implements ExceptionHandlingService {
    protected NuxeoExceptionHandler exceptionHandler;
    protected final NuxeoExceptionHandlerParameters exceptionHandlerParameters = new NuxeoExceptionHandlerParameters();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        ExtensionPoint ep = Enum.valueOf(ExtensionPoint.class, extensionPoint);
        switch (ep) {
            case exceptionhandler: {
                ExceptionHandlerDescriptor ehd = (ExceptionHandlerDescriptor)contribution;
                this.exceptionHandler = this.newInstance(ehd.getKlass());
                this.exceptionHandler.setParameters(this.exceptionHandlerParameters);
                break;
            }
            case errorhandlers: {
                ErrorHandlersDescriptor md = (ErrorHandlersDescriptor)contribution;
                this.exceptionHandlerParameters.setBundleName(md.getBundle());
                this.exceptionHandlerParameters.setHandlers(md.getMessages());
                this.exceptionHandlerParameters.setLoggerName(md.getLoggerName());
                this.exceptionHandlerParameters.setDefaultErrorPage(md.getDefaultPage());
                break;
            }
            case requestdump: {
                RequestDumpDescriptor rdd = (RequestDumpDescriptor)contribution;
                RequestDumper dumper = this.newInstance(rdd.getKlass());
                List<String> attributes = rdd.getAttributes();
                dumper.setNotListedAttributes(attributes);
                this.exceptionHandlerParameters.setRequestDumper(dumper);
                break;
            }
            case listener: {
                ListenerDescriptor ld = (ListenerDescriptor)contribution;
                this.exceptionHandlerParameters.setListener(this.newInstance(ld.getKlass()));
                break;
            }
            default: {
                throw new RuntimeException("error in exception handling configuration");
            }
        }
    }

    protected <T> T newInstance(Class<T> klass) {
        try {
            return klass.newInstance();
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void forwardToErrorPage(HttpServletRequest request, HttpServletResponse response, Throwable t) throws IOException, ServletException {
        this.exceptionHandler.handleException(request, response, t);
    }

    @Override
    public NuxeoExceptionHandler getExceptionHandler() {
        return this.exceptionHandler;
    }

    public static enum ExtensionPoint {
        exceptionhandler,
        errorhandlers,
        requestdump,
        listener;

    }
}

