/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.launcher.config;

import freemarker.template.TemplateException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.xml.DOMConfigurator;
import org.nuxeo.common.codec.Crypto;
import org.nuxeo.common.codec.CryptoProperties;
import org.nuxeo.common.utils.TextTemplate;
import org.nuxeo.connect.update.LocalPackage;
import org.nuxeo.connect.update.Package;
import org.nuxeo.launcher.config.ConfigurationException;
import org.nuxeo.launcher.config.ConfigurationGenerator;
import org.nuxeo.launcher.info.ConfigurationInfo;
import org.nuxeo.launcher.info.DistributionInfo;
import org.nuxeo.launcher.info.InstanceInfo;
import org.nuxeo.launcher.info.KeyValueInfo;
import org.nuxeo.launcher.info.PackageInfo;

public abstract class ServerConfigurator {
    protected static final Log log = LogFactory.getLog(ServerConfigurator.class);
    protected final ConfigurationGenerator generator;
    protected File dataDir = null;
    protected File logDir = null;
    protected File pidDir = null;
    protected File tmpDir = null;
    protected File packagesDir = null;
    public static final List<String> NUXEO_SYSTEM_PROPERTIES = Arrays.asList("nuxeo.conf", "nuxeo.home", "log.id");
    protected static final String DEFAULT_CONTEXT_NAME = "/nuxeo";
    public static final String JAVA_OPTS = "JAVA_OPTS";
    private static final String NEW_FILES = "templates" + File.separator + "files.list";
    @Deprecated
    public static final String DEFAULT_LOG_DIR = "log";
    @Deprecated
    public static final String DEFAULT_DATA_DIR = "data";
    @Deprecated
    public static final String DEFAULT_TMP_DIR = "tmp";

    public ServerConfigurator(ConfigurationGenerator configurationGenerator) {
        this.generator = configurationGenerator;
    }

    abstract boolean isConfigured();

    protected void parseAndCopy(Properties config) throws IOException, TemplateException, ConfigurationException {
        FilenameFilter filter = (dir, name) -> !"nuxeo.defaults".equals(name);
        TextTemplate templateParser = new TextTemplate(config);
        templateParser.setKeepEncryptedAsVar(true);
        templateParser.setTrim(true);
        templateParser.setTextParsingExtensions(config.getProperty("nuxeo.plaintext_parsing_extensions", "xml,properties,nx"));
        templateParser.setFreemarkerParsingExtensions(config.getProperty("nuxeo.freemarker_parsing_extensions", "nxftl"));
        this.deleteTemplateFiles();
        ArrayList<String> newFilesList = new ArrayList<String>();
        for (File includedTemplate : this.generator.getIncludedTemplates()) {
            String outputDirectoryStr;
            Object[] listFiles = includedTemplate.listFiles(filter);
            if (listFiles == null) continue;
            String templateName = includedTemplate.getName();
            log.debug((Object)String.format("Parsing %s... %s", templateName, Arrays.toString(listFiles)));
            Boolean isDeprecated = Boolean.valueOf(config.getProperty(templateName + ".deprecated"));
            if (isDeprecated.booleanValue()) {
                log.warn((Object)("WARNING: Template " + templateName + " is deprecated."));
                String deprecationMessage = config.getProperty(templateName + ".deprecation");
                if (deprecationMessage != null) {
                    log.warn((Object)deprecationMessage);
                }
            }
            File outputDirectory = (outputDirectoryStr = config.getProperty(templateName + ".target")) != null ? new File(this.generator.getNuxeoHome(), outputDirectoryStr) : this.getOutputDirectory();
            for (Object in : listFiles) {
                newFilesList.addAll(templateParser.processDirectory((File)in, new File(outputDirectory, ((File)in).getName())));
            }
        }
        this.storeNewFilesList(newFilesList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTemplateFiles() throws IOException, ConfigurationException {
        File newFiles = new File(this.generator.getNuxeoHome(), NEW_FILES);
        if (!newFiles.exists()) {
            return;
        }
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(newFiles));
            while ((line = reader.readLine()) != null) {
                if (line.endsWith(".bak")) {
                    log.debug((Object)("Restore " + line));
                    try {
                        File backup = new File(this.generator.getNuxeoHome(), line);
                        File original = new File(this.generator.getNuxeoHome(), line.substring(0, line.length() - 4));
                        FileUtils.copyFile((File)backup, (File)original);
                        backup.delete();
                        continue;
                    }
                    catch (IOException e) {
                        throw new ConfigurationException(String.format("Failed to restore %s from %s\nEdit or delete %s to bypass that error.", line.substring(0, line.length() - 4), line, newFiles), e);
                    }
                }
                log.debug((Object)("Remove " + line));
                new File(this.generator.getNuxeoHome(), line).delete();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        newFiles.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeNewFilesList(List<String> newFilesList) throws IOException {
        BufferedWriter writer = null;
        try {
            File newFiles = new File(this.generator.getNuxeoHome(), NEW_FILES);
            writer = new BufferedWriter(new FileWriter(newFiles, false));
            int index = this.generator.getNuxeoHome().getCanonicalPath().length() + 1;
            for (String filepath : newFilesList) {
                writer.write(new File(filepath).getCanonicalPath().substring(index));
                writer.newLine();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(writer);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)writer);
    }

    protected File getOutputDirectory() {
        return this.getRuntimeHome();
    }

    protected String getDefaultDataDir() {
        return DEFAULT_DATA_DIR;
    }

    protected abstract File getRuntimeHome();

    public File getDataDir() {
        if (this.dataDir == null) {
            this.dataDir = new File(this.generator.getNuxeoHome(), this.getDefaultDataDir());
        }
        return this.dataDir;
    }

    public File getLogDir() {
        if (this.logDir == null) {
            this.logDir = new File(this.generator.getNuxeoHome(), DEFAULT_LOG_DIR);
        }
        return this.logDir;
    }

    public void setDataDir(String dataDirStr) {
        this.dataDir = new File(dataDirStr);
        this.dataDir.mkdirs();
    }

    public void setLogDir(String logDirStr) {
        this.logDir = new File(logDirStr);
        this.logDir.mkdirs();
    }

    public void initLogs() {
        File logFile = this.getLogConfFile();
        try {
            String logDirectory = System.getProperty("nuxeo.log.dir");
            if (logDirectory == null) {
                System.setProperty("nuxeo.log.dir", this.getLogDir().getPath());
            }
            if (logFile == null || !logFile.exists()) {
                System.out.println("No logs configuration, will setup a basic one.");
                BasicConfigurator.configure();
            } else {
                System.out.println("Try to configure logs with " + logFile);
                DOMConfigurator.configure((URL)logFile.toURI().toURL());
            }
            log.info((Object)"Logs successfully configured.");
        }
        catch (MalformedURLException e) {
            log.error((Object)("Could not initialize logs with " + logFile), (Throwable)e);
        }
    }

    public File getPidDir() {
        if (this.pidDir == null) {
            this.pidDir = this.getLogDir();
        }
        return this.pidDir;
    }

    public void setPidDir(String pidDirStr) {
        this.pidDir = new File(pidDirStr);
        this.pidDir.mkdirs();
    }

    public void checkPaths() throws ConfigurationException {
        File oldPackagesPath;
        File badInstanceClid = new File(this.generator.getNuxeoHome(), this.getDefaultDataDir() + File.separator + "instance.clid");
        if (badInstanceClid.exists() && !this.getDataDir().equals(badInstanceClid.getParentFile())) {
            log.warn((Object)String.format("Moving %s to %s.", badInstanceClid, this.getDataDir()));
            try {
                FileUtils.moveFileToDirectory((File)badInstanceClid, (File)this.getDataDir(), (boolean)true);
            }
            catch (IOException e) {
                throw new ConfigurationException("NXP-6722 move failed: " + e.getMessage(), e);
            }
        }
        if ((oldPackagesPath = new File(this.getDataDir(), this.getDefaultPackagesDir())).exists() && !oldPackagesPath.equals(this.getPackagesDir())) {
            log.warn((Object)String.format("NXP-8014 Packages cache location changed. You can safely delete %s or move its content to %s", oldPackagesPath, this.getPackagesDir()));
        }
    }

    public File getTmpDir() {
        if (this.tmpDir == null) {
            this.tmpDir = new File(this.generator.getNuxeoHome(), this.getDefaultTmpDir());
        }
        return this.tmpDir;
    }

    public String getDefaultTmpDir() {
        return DEFAULT_TMP_DIR;
    }

    public void setTmpDir(String tmpDirStr) {
        this.tmpDir = new File(tmpDirStr);
        this.tmpDir.mkdirs();
    }

    public void setDirectory(String key, String directory) {
        String absoluteDirectory = this.setAbsolutePath(key, directory);
        if ("nuxeo.data.dir".equals(key)) {
            this.setDataDir(absoluteDirectory);
        } else if ("nuxeo.log.dir".equals(key)) {
            this.setLogDir(absoluteDirectory);
        } else if ("nuxeo.pid.dir".equals(key)) {
            this.setPidDir(absoluteDirectory);
        } else if ("nuxeo.tmp.dir".equals(key)) {
            this.setTmpDir(absoluteDirectory);
        } else if ("nuxeo.mp.dir".equals(key)) {
            this.setPackagesDir(absoluteDirectory);
        } else {
            log.error((Object)("Unknown directory key: " + key));
        }
    }

    private void setPackagesDir(String packagesDirStr) {
        this.packagesDir = new File(packagesDirStr);
        this.packagesDir.mkdirs();
    }

    private String setAbsolutePath(String key, String directory) {
        if (!new File(directory).isAbsolute()) {
            directory = new File(this.generator.getNuxeoHome(), directory).getPath();
            this.generator.getUserConfig().setProperty(key, directory);
        }
        return directory;
    }

    public File getDirectory(String key) {
        if ("nuxeo.data.dir".equals(key)) {
            return this.getDataDir();
        }
        if ("nuxeo.log.dir".equals(key)) {
            return this.getLogDir();
        }
        if ("nuxeo.pid.dir".equals(key)) {
            return this.getPidDir();
        }
        if ("nuxeo.tmp.dir".equals(key)) {
            return this.getTmpDir();
        }
        if ("nuxeo.mp.dir".equals(key)) {
            return this.getPackagesDir();
        }
        log.error((Object)("Unknown directory key: " + key));
        return null;
    }

    protected void checkPath(File oldPath, String message) throws ConfigurationException {
        if (oldPath.exists()) {
            log.error((Object)"Deprecated paths used.");
            throw new ConfigurationException(message);
        }
    }

    public abstract File getLogConfFile();

    public abstract File getConfigDir();

    public void prepareWizardStart() {
    }

    public void cleanupPostWizard() {
    }

    public boolean isWizardAvailable() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void dumpProperties(CryptoProperties userConfig) {
        Properties dumpedProperties = this.filterSystemProperties(userConfig);
        File dumpedFile = this.generator.getDumpedConfig();
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(dumpedFile, false);
            dumpedProperties.store(os, "Generated by " + this.getClass());
        }
        catch (FileNotFoundException e) {
            log.error((Object)e);
            IOUtils.closeQuietly((OutputStream)os);
        }
        catch (IOException e2) {
            log.error((Object)("Could not dump properties to " + dumpedFile), (Throwable)e2);
            {
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(os);
                    throw throwable;
                }
            }
            IOUtils.closeQuietly((OutputStream)os);
        }
        IOUtils.closeQuietly((OutputStream)os);
    }

    public Properties filterSystemProperties(CryptoProperties properties) {
        Properties dumpedProperties = new Properties();
        Enumeration propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String key = (String)propertyNames.nextElement();
            if (System.getProperties().containsKey(key) && !NUXEO_SYSTEM_PROPERTIES.contains(key)) continue;
            dumpedProperties.setProperty(key, properties.getRawProperty(key));
        }
        return dumpedProperties;
    }

    public File getNuxeoLibDir() {
        return new File(this.getRuntimeHome(), "lib");
    }

    public abstract File getServerLibDir();

    public void verifyInstallation() throws ConfigurationException {
        this.checkPaths();
        this.checkNetwork();
    }

    protected void checkNetwork() throws ConfigurationException {
    }

    protected void addServerSpecificParameters(Map<String, String> parametersmigration) {
    }

    public File getPackagesDir() {
        if (this.packagesDir == null) {
            this.packagesDir = new File(this.generator.getNuxeoHome(), this.getDefaultPackagesDir());
        }
        return this.packagesDir;
    }

    public String getDefaultPackagesDir() {
        return "packages";
    }

    public InstanceInfo getInfo(String clid, List<LocalPackage> pkgs) {
        InstanceInfo nxInstance = new InstanceInfo();
        nxInstance.NUXEO_CONF = this.generator.getNuxeoConf().getPath();
        nxInstance.NUXEO_HOME = this.generator.getNuxeoHome().getPath();
        File distFile = new File(this.generator.getConfigDir(), "distribution.properties");
        if (!distFile.exists()) {
            distFile = new File(this.generator.getNuxeoHome(), "templates");
            distFile = new File(distFile, "common");
            distFile = new File(distFile, "config");
            distFile = new File(distFile, "distribution.properties");
        }
        try {
            nxInstance.distribution = new DistributionInfo(distFile);
        }
        catch (IOException e) {
            nxInstance.distribution = new DistributionInfo();
        }
        nxInstance.clid = clid;
        HashSet<String> pkgTemplates = new HashSet<String>();
        for (LocalPackage pkg : pkgs) {
            PackageInfo info = new PackageInfo((Package)pkg);
            nxInstance.packages.add(info);
            pkgTemplates.addAll(info.templates);
        }
        nxInstance.config = new ConfigurationInfo();
        nxInstance.config.dbtemplate = this.generator.extractDatabaseTemplateName();
        String userTemplates = this.generator.getUserTemplates();
        StringTokenizer st = new StringTokenizer(userTemplates, ",");
        while (st.hasMoreTokens()) {
            String template = st.nextToken();
            if (template.equals(nxInstance.config.dbtemplate)) continue;
            if (pkgTemplates.contains(template)) {
                nxInstance.config.pkgtemplates.add(template);
                continue;
            }
            File testBase = new File(this.generator.getNuxeoHome(), "templates" + File.separator + template);
            if (testBase.exists()) {
                nxInstance.config.basetemplates.add(template);
                continue;
            }
            nxInstance.config.usertemplates.add(template);
        }
        CryptoProperties userConfig = this.generator.getUserConfig();
        for (Object item : new TreeSet(userConfig.keySet())) {
            String key = (String)item;
            String value = userConfig.getRawProperty(key);
            if (JAVA_OPTS.equals(key)) {
                value = this.generator.getJavaOptsString();
            }
            if (ConfigurationGenerator.SECRET_KEYS.contains(key) || key.contains("password") || key.equals("server.status.key") || Crypto.isEncrypted((String)value)) {
                value = "********";
            }
            nxInstance.config.keyvals.add(new KeyValueInfo(key, value));
        }
        return nxInstance;
    }
}

