/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.preview.adapter;

import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.preview.adapter.AbstractPreviewer;
import org.nuxeo.ecm.platform.preview.adapter.MimeTypePreviewer;
import org.nuxeo.ecm.platform.preview.api.PreviewException;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;

public class ImagePreviewer
extends AbstractPreviewer
implements MimeTypePreviewer {
    protected Blob getContentBlob(Blob original, DocumentModel doc) {
        return original;
    }

    @Override
    public List<Blob> getPreview(Blob blob, DocumentModel dm) throws PreviewException {
        ArrayList<Blob> blobResults = new ArrayList<Blob>();
        String basePath = VirtualHostHelper.getContextPathProperty();
        StringBuffer html = new StringBuffer();
        html.append("<html><head>");
        html.append("<title>" + this.getPreviewTitle(dm) + "</title>");
        html.append(String.format("<script src=\"%s/bower_components/webcomponentsjs/webcomponents-lite.js\"></script>", basePath));
        html.append(String.format("<link rel=\"import\" href=\"%s/viewers/nuxeo-image-viewer.vulcanized.html\">", basePath));
        html.append("<style>");
        html.append("nuxeo-image-viewer {");
        html.append("height: 100%; }");
        html.append("</style>");
        html.append("</head><body>");
        html.append("<nuxeo-image-viewer src=\"image\" controls responsive></nuxeo-image-viewer>");
        html.append("</body>");
        Blob mainBlob = Blobs.createBlob((String)html.toString(), (String)"text/html", null, (String)"index.html");
        blobResults.add(mainBlob);
        Blob content = this.getContentBlob(blob, dm);
        content.setFilename("image");
        blobResults.add(content);
        return blobResults;
    }
}

