/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.lifecycle.event;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.NXCore;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.PostCommitEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class BulkLifeCycleChangeListener
implements PostCommitEventListener {
    public static final String PAGINATE_GET_CHILDREN_PROPERTY = "nuxeo.bulkLifeCycleChangeListener.paginate-get-children";
    public static final String GET_CHILDREN_PAGE_SIZE_PROPERTY = "nuxeo.bulkLifeCycleChangeListener.get-children-page-size";
    private static final Log log = LogFactory.getLog(BulkLifeCycleChangeListener.class);

    public void handleEvent(EventBundle events) {
        if (!(events.containsEventName("lifecycle_transition_event") || events.containsEventName("documentUndeleted") || events.containsEventName("documentCreatedByCopy"))) {
            return;
        }
        for (Event event : events) {
            String name = event.getName();
            if (!"lifecycle_transition_event".equals(name) && !"documentUndeleted".equals(name) && !"documentCreatedByCopy".equals(name)) continue;
            this.processTransition(event);
        }
    }

    protected void processTransition(Event event) {
        log.debug((Object)"Processing lifecycle change in async listener");
        EventContext ctx = event.getContext();
        if (!(ctx instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)ctx;
        DocumentModel doc = docCtx.getSourceDocument();
        if (!doc.isFolder() && !"documentCreatedByCopy".equals(event.getName())) {
            return;
        }
        CoreSession session = docCtx.getCoreSession();
        if (session == null) {
            log.error((Object)"Can not process lifeCycle change since session is null");
            return;
        }
        if ("documentCreatedByCopy".equals(event.getName())) {
            if (!Boolean.TRUE.equals(event.getContext().getProperties().get("resetLifeCycle"))) {
                return;
            }
            DocumentModelListImpl docs = new DocumentModelListImpl();
            docs.add((Object)doc);
            if (session.exists(doc.getRef())) {
                this.reinitDocumentsLifeCyle(session, (DocumentModelList)docs);
                session.save();
            }
        } else {
            String targetState;
            String transition;
            if ("lifecycle_transition_event".equals(event.getName())) {
                transition = (String)((Object)docCtx.getProperty("transition"));
                if (this.isNonRecursiveTransition(transition, doc.getType())) {
                    return;
                }
                if ("undelete".equals(transition)) {
                    return;
                }
                targetState = (String)((Object)docCtx.getProperty("to"));
            } else {
                transition = "undelete";
                targetState = "";
            }
            this.changeChildrenState(session, transition, targetState, doc);
        }
    }

    protected void reinitDocumentsLifeCyle(CoreSession documentManager, DocumentModelList docs) {
        for (DocumentModel docMod : docs) {
            documentManager.reinitLifeCycleState(docMod.getRef());
            if (!docMod.isFolder()) continue;
            DocumentModelList children = documentManager.query(String.format("SELECT * FROM Document WHERE ecm:currentLifeCycleState != 'deleted' AND ecm:parentId = '%s'", docMod.getRef()));
            this.reinitDocumentsLifeCyle(documentManager, children);
        }
    }

    protected boolean isNonRecursiveTransition(String transition, String type) {
        List<String> nonRecursiveTransitions = NXCore.getLifeCycleService().getNonRecursiveTransitionForDocType(type);
        return nonRecursiveTransitions.contains(transition);
    }

    protected void changeChildrenState(CoreSession session, String transition, String targetState, DocumentModel doc) {
        ConfigurationService confService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        boolean paginate = confService.isBooleanPropertyTrue(PAGINATE_GET_CHILDREN_PROPERTY);
        if (paginate) {
            long pageSize = Long.parseLong(confService.getProperty(GET_CHILDREN_PAGE_SIZE_PROPERTY, "500"));
            String query = String.format("SELECT * FROM Document where ecm:parentId ='%s'", doc.getId());
            DocumentModelList documents = session.query(query, null, pageSize, 0L, true);
            this.changeDocumentsState(session, transition, targetState, documents);
            session.save();
            TransactionHelper.commitOrRollbackTransaction();
            long nbChildren = documents.totalSize();
            for (long offset = pageSize; offset < nbChildren; offset += pageSize) {
                long i = offset;
                TransactionHelper.runInTransaction(() -> {
                    DocumentModelList docs = session.query(query, null, pageSize, i, false);
                    this.changeDocumentsState(session, transition, targetState, docs);
                    session.save();
                });
            }
            TransactionHelper.startTransaction();
        } else {
            DocumentModelList documents = session.getChildren(doc.getRef());
            this.changeDocumentsState(session, transition, targetState, documents);
            session.save();
        }
    }

    protected void changeDocumentsState(CoreSession session, String transition, String targetState, DocumentModelList docs) {
        for (DocumentModel doc : docs) {
            if (doc.getCurrentLifeCycleState() == null) {
                if (!"deleted".equals(targetState)) continue;
                log.debug((Object)"Doc has no lifecycle, deleting ...");
                session.removeDocument(doc.getRef());
                continue;
            }
            if (doc.getAllowedStateTransitions().contains(transition) && !doc.isProxy()) {
                doc.followTransition(transition);
                continue;
            }
            if (targetState.equals(doc.getCurrentLifeCycleState())) {
                log.debug((Object)("Document" + doc.getRef() + " is already in the target LifeCycle state"));
                continue;
            }
            if ("deleted".equals(targetState)) {
                log.debug((Object)("Impossible to change state of " + doc.getRef() + " :removing"));
                session.removeDocument(doc.getRef());
                continue;
            }
            log.debug((Object)("Document" + doc.getRef() + " has no transition to the target LifeCycle state"));
        }
    }

    @Deprecated
    protected void changeDocumentsState(CoreSession session, DocumentModelList docs, String transition, String targetState) {
        this.changeDocumentsState(session, transition, targetState, docs);
    }
}

