/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.cache.Cache;
import org.nuxeo.ecm.core.cache.CacheDescriptor;
import org.nuxeo.ecm.core.cache.CacheManagement;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.pubsub.AbstractPubSubBroker;
import org.nuxeo.runtime.pubsub.SerializableMessage;

public class CacheServiceImpl
extends DefaultComponent
implements CacheService {
    private static final Log log = LogFactory.getLog(CacheServiceImpl.class);
    public static final ComponentName NAME = new ComponentName(CacheServiceImpl.class.getName());
    protected static final Random RANDOM = new Random();
    public static final String DEFAULT_CACHE_ID = "default-cache";
    public static final String CACHE_INVAL_PUBSUB_TOPIC = "cacheinval";
    public static final String CLUSTERING_ENABLED_PROP = "repository.clustering.enabled";
    public static final String NODE_ID_PROP = "repository.clustering.id";
    protected final CacheDescriptorRegistry registry = new CacheDescriptorRegistry();
    protected final Map<String, CacheManagement> caches = new ConcurrentHashMap<String, CacheManagement>();
    protected CachePubSubInvalidator invalidator;

    public void registerContribution(Object contrib, String extensionPoint, ComponentInstance contributor) {
        this.registerCacheDescriptor((CacheDescriptor)contrib);
    }

    @Override
    @Deprecated
    public void registerCache(String name, int maxSize, int timeout) {
        this.registerCache(name);
    }

    @Override
    public void registerCache(String name) {
        CacheDescriptor defaultDescriptor = this.registry.getDefaultDescriptor().clone();
        defaultDescriptor.name = name;
        this.registerCacheDescriptor(defaultDescriptor);
        this.maybeStart(name);
    }

    public void registerCacheDescriptor(CacheDescriptor descriptor) {
        this.registry.addContribution(descriptor);
        log.info((Object)("Cache registered: " + descriptor.name));
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        this.unregisterCacheDescriptor((CacheDescriptor)contribution);
    }

    public void unregisterCacheDescriptor(CacheDescriptor descriptor) {
        this.registry.removeContribution(descriptor);
        log.info((Object)("Cache unregistered: " + descriptor.name));
    }

    public int getApplicationStartedOrder() {
        ComponentInstance repositoryComponent = Framework.getRuntime().getComponentInstance("org.nuxeo.ecm.core.repository.RepositoryServiceComponent");
        if (repositoryComponent == null || repositoryComponent.getInstance() == null) {
            return super.getApplicationStartedOrder();
        }
        return ((DefaultComponent)repositoryComponent.getInstance()).getApplicationStartedOrder() - 5;
    }

    public void start(ComponentContext context) {
        if (Framework.isBooleanPropertyTrue((String)CLUSTERING_ENABLED_PROP)) {
            String nodeId = Framework.getProperty((String)NODE_ID_PROP);
            if (StringUtils.isBlank((CharSequence)nodeId)) {
                nodeId = String.valueOf(RANDOM.nextLong());
                log.warn((Object)("Missing cluster node id configuration, please define it explicitly (usually through repository.clustering.id). Using random cluster node id instead: " + nodeId));
            } else {
                nodeId = nodeId.trim();
            }
            this.invalidator = new CachePubSubInvalidator();
            this.invalidator.initialize(CACHE_INVAL_PUBSUB_TOPIC, nodeId);
            log.info((Object)("Registered cache invalidator for node: " + nodeId));
        } else {
            log.info((Object)"Not registering a cache invalidator because clustering is not enabled");
        }
        this.registry.getCacheDescriptors().forEach(this::startCacheDescriptor);
    }

    protected void startCacheDescriptor(CacheDescriptor desc) {
        CacheManagement cache = desc.newInstance(this.invalidator);
        cache.start();
        this.caches.put(desc.name, cache);
    }

    public void stop(ComponentContext context) {
        if (this.invalidator != null) {
            this.invalidator.close();
            this.invalidator = null;
        }
        for (CacheManagement cache : this.caches.values()) {
            cache.stop();
        }
        this.caches.clear();
    }

    protected void maybeStart(String name) {
        if (!Framework.getRuntime().getComponentManager().isStarted()) {
            return;
        }
        CacheManagement cache = this.caches.get(name);
        if (cache != null) {
            cache.stop();
        }
        this.startCacheDescriptor(this.registry.getCacheDescriptor(name));
    }

    @Override
    public Cache getCache(String name) {
        return this.caches.get(name);
    }

    public CacheDescriptor getCacheDescriptor(String descriptor) {
        return this.registry.getCacheDescriptor(descriptor);
    }

    protected class CachePubSubInvalidator
    extends AbstractCachePubSubInvalidator {
        protected CachePubSubInvalidator() {
        }

        @Override
        protected Cache getCache(String name) {
            return CacheServiceImpl.this.getCache(name);
        }
    }

    protected static abstract class AbstractCachePubSubInvalidator
    extends AbstractPubSubBroker<CacheInvalidation> {
        public static final String ALL_KEYS = "__ALL__";

        protected AbstractCachePubSubInvalidator() {
        }

        public CacheInvalidation deserialize(InputStream in) throws IOException {
            return CacheInvalidation.deserialize(in);
        }

        public void sendInvalidation(String cacheName, String key) {
            this.sendMessage(new CacheInvalidation(cacheName, key));
        }

        public void sendInvalidationsAll(String cacheName) {
            this.sendMessage(new CacheInvalidation(cacheName, ALL_KEYS));
        }

        public void receivedMessage(CacheInvalidation invalidation) {
            CacheManagement cache = (CacheManagement)this.getCache(invalidation.cacheName);
            if (cache != null) {
                String key = invalidation.key;
                if (ALL_KEYS.equals(key)) {
                    cache.invalidateLocalAll();
                } else {
                    cache.invalidateLocal(key);
                }
            }
        }

        protected abstract Cache getCache(String var1);
    }

    protected static class CacheInvalidation
    implements SerializableMessage {
        private static final long serialVersionUID = 1L;
        protected static final String SEP = "/";
        public final String cacheName;
        public final String key;

        public CacheInvalidation(String name, String key) {
            this.cacheName = name;
            this.key = key;
        }

        public void serialize(OutputStream out) throws IOException {
            String string = this.cacheName + SEP + this.key;
            IOUtils.write((String)string, (OutputStream)out, (Charset)StandardCharsets.UTF_8);
        }

        public static CacheInvalidation deserialize(InputStream in) throws IOException {
            String string = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            String[] parts = string.split(SEP, 2);
            if (parts.length != 2) {
                throw new IOException("Invalid invalidation: " + string);
            }
            String cacheName = parts[0];
            String key = parts[1];
            return new CacheInvalidation(cacheName, key);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.cacheName + "," + this.key + ")";
        }
    }

    protected static class CacheDescriptorRegistry {
        protected Map<String, List<CacheDescriptor>> allDescriptors = new ConcurrentHashMap<String, List<CacheDescriptor>>();
        protected Map<String, CacheDescriptor> effectiveDescriptors = new ConcurrentHashMap<String, CacheDescriptor>();

        protected CacheDescriptorRegistry() {
        }

        public void addContribution(CacheDescriptor descriptor) {
            String name = descriptor.name;
            this.allDescriptors.computeIfAbsent(name, n -> new CopyOnWriteArrayList()).add(descriptor);
            this.recompute(name);
        }

        public void removeContribution(CacheDescriptor descriptor) {
            String name = descriptor.name;
            this.allDescriptors.getOrDefault(name, Collections.emptyList()).remove(descriptor);
            this.recompute(name);
        }

        protected void recompute(String name) {
            CacheDescriptor desc = null;
            for (CacheDescriptor d : this.allDescriptors.getOrDefault(name, Collections.emptyList())) {
                if (d.remove) {
                    desc = null;
                    continue;
                }
                if (desc == null) {
                    desc = d.clone();
                    continue;
                }
                desc.merge(d);
            }
            if (desc == null) {
                this.effectiveDescriptors.remove(name);
            } else {
                this.effectiveDescriptors.put(name, desc);
            }
        }

        public CacheDescriptor getCacheDescriptor(String name) {
            return this.effectiveDescriptors.get(name);
        }

        public Collection<CacheDescriptor> getCacheDescriptors() {
            return this.effectiveDescriptors.values();
        }

        public CacheDescriptor getDefaultDescriptor() {
            CacheDescriptor defaultDescriptor = this.getCacheDescriptor(CacheServiceImpl.DEFAULT_CACHE_ID);
            if (defaultDescriptor == null) {
                defaultDescriptor = new CacheDescriptor();
                defaultDescriptor.ttl = 1L;
                defaultDescriptor.options.put("maxSize", String.valueOf(100L));
            }
            return defaultDescriptor;
        }
    }
}

