/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.transientstore;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreConfig;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreProvider;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class TransientStorageComponent
extends DefaultComponent
implements TransientStoreService {
    protected Map<String, TransientStoreConfig> configs = new HashMap<String, TransientStoreConfig>();
    protected Map<String, TransientStoreProvider> stores = new HashMap<String, TransientStoreProvider>();
    public static final String EP_STORE = "store";
    public static final String DEFAULT_STORE_NAME = "default";

    @Override
    public TransientStore getStore(String name) {
        TransientStore store = this.stores.get(name);
        if (store == null && (store = (TransientStore)this.stores.get(DEFAULT_STORE_NAME)) == null) {
            store = this.registerDefaultStore();
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TransientStore registerDefaultStore() {
        TransientStorageComponent transientStorageComponent = this;
        synchronized (transientStorageComponent) {
            TransientStoreProvider defaultStore = this.stores.get(DEFAULT_STORE_NAME);
            if (defaultStore == null) {
                TransientStoreConfig defaultConfig = new TransientStoreConfig(DEFAULT_STORE_NAME);
                defaultStore = defaultConfig.getStore();
                this.stores.put(defaultConfig.getName(), defaultStore);
            }
            return defaultStore;
        }
    }

    @Override
    public void doGC() {
        this.stores.values().forEach(TransientStoreProvider::doGC);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EP_STORE.equals(extensionPoint)) {
            TransientStoreConfig config = (TransientStoreConfig)contribution;
            this.configs.put(config.getName(), config);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EP_STORE.equals(extensionPoint)) {
            TransientStoreConfig config = (TransientStoreConfig)contribution;
            TransientStoreProvider store = this.stores.get(config.getName());
            store.shutdown();
        }
    }

    public void start(ComponentContext context) {
        for (TransientStoreConfig config : this.configs.values()) {
            this.registerStore(config);
        }
    }

    protected TransientStore registerStore(TransientStoreConfig config) {
        TransientStoreProvider store = config.getStore();
        this.stores.put(config.getName(), store);
        return store;
    }

    public void deactivate(ComponentContext context) {
        this.stores.values().forEach(TransientStoreProvider::shutdown);
        this.stores.clear();
        this.configs.values().forEach(TransientStoreConfig::flush);
        super.deactivate(context);
    }

    public void cleanUpStores() {
        this.stores.values().forEach(TransientStoreProvider::removeAll);
    }
}

