/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.el;

import java.util.ArrayList;
import java.util.List;
import javax.el.ELContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.platform.el.DefaultELContextFactory;
import org.nuxeo.ecm.platform.el.ELContextFactory;
import org.nuxeo.ecm.platform.el.ELContextFactoryDescriptor;
import org.nuxeo.ecm.platform.el.ELService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class ELServiceComponent
extends DefaultComponent
implements ELService {
    private static final Log log = LogFactory.getLog(ELServiceComponent.class);
    private static final String XP_EL_CONTEXT_FACTORY = "elContextFactory";
    protected static final ELContextFactory DEFAULT_EL_CONTEXT_FACTORY = new DefaultELContextFactory();
    protected List<ELContextFactoryDescriptor> elContextFactoryDescriptors;
    protected ELContextFactory elContextFactory = DEFAULT_EL_CONTEXT_FACTORY;

    public void activate(ComponentContext context) {
        this.elContextFactoryDescriptors = new ArrayList<ELContextFactoryDescriptor>(1);
    }

    public void deactivate(ComponentContext context) {
        this.elContextFactoryDescriptors.clear();
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (!XP_EL_CONTEXT_FACTORY.equals(extensionPoint)) {
            throw new NuxeoException("Unknown extension point: " + extensionPoint);
        }
        ELContextFactoryDescriptor desc = (ELContextFactoryDescriptor)contribution;
        log.info((Object)("Registered ELContextFactory: " + desc.klass.getName()));
        this.registerELContextFactoryDescriptor(desc);
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (!XP_EL_CONTEXT_FACTORY.equals(extensionPoint)) {
            throw new NuxeoException("Unknown extension point: " + extensionPoint);
        }
        ELContextFactoryDescriptor desc = (ELContextFactoryDescriptor)contribution;
        log.info((Object)("Unregistered ELContextFactory: " + desc.klass.getName()));
        this.unregisterELContextFactoryDescriptor(desc);
    }

    public void registerELContextFactoryDescriptor(ELContextFactoryDescriptor desc) {
        this.elContextFactoryDescriptors.add(desc);
        this.elContextFactory = desc.newInstance();
    }

    public void unregisterELContextFactoryDescriptor(ELContextFactoryDescriptor desc) {
        this.elContextFactoryDescriptors.remove(desc);
        if (this.elContextFactoryDescriptors.isEmpty()) {
            this.elContextFactory = DEFAULT_EL_CONTEXT_FACTORY;
        } else {
            desc = this.elContextFactoryDescriptors.get(this.elContextFactoryDescriptors.size() - 1);
            this.elContextFactory = desc.newInstance();
        }
    }

    @Override
    public ELContext createELContext() {
        return (ELContext)this.elContextFactory.get();
    }
}

