/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.metrics;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.metrics.MetricsDescriptor;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class MetricsServiceImpl
extends DefaultComponent
implements MetricsService {
    protected static final Log log = LogFactory.getLog(MetricsServiceImpl.class);
    protected MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    private final Counter instanceUp = this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"instance-up"}));
    protected static final String CONFIGURATION_EP = "configuration";
    public static MetricsDescriptor config;

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIGURATION_EP.equals(extensionPoint) && contribution instanceof MetricsDescriptor) {
            log.debug((Object)"Registering metrics contribution");
            config = (MetricsDescriptor)contribution;
        } else {
            log.warn((Object)("Unknown EP " + extensionPoint));
        }
    }

    public void activate(ComponentContext context) {
        SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    }

    public void deactivate(ComponentContext context) {
        SharedMetricRegistries.remove((String)MetricsService.class.getName());
        log.debug((Object)"Deactivate component.");
    }

    public void start(ComponentContext context) {
        if (config == null) {
            config = new MetricsDescriptor();
        }
        log.info((Object)"Setting up metrics configuration");
        config.enable(this.registry);
        this.instanceUp.inc();
    }

    public void stop(ComponentContext context) {
        try {
            config.disable(this.registry);
        }
        finally {
            this.instanceUp.dec();
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(MetricRegistry.class)) {
            return adapter.cast(this.registry);
        }
        return (T)super.getAdapter(adapter);
    }
}

