/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.mimetype.detectors;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.sf.jmimemagic.MagicDetector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.runtime.api.Framework;

public class PptMimetypeSniffer
implements MagicDetector {
    private static final Log log = LogFactory.getLog(PptMimetypeSniffer.class);

    public String getDisplayName() {
        return "PPT MimeType Detector";
    }

    public String[] getHandledExtensions() {
        return new String[]{"ppt", "pps"};
    }

    public String[] getHandledTypes() {
        return new String[]{"application/vnd.ms-powerpoint"};
    }

    public String getName() {
        return "pptdetector";
    }

    public String getVersion() {
        return "0.1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] process(byte[] data, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        String[] mimetypes = new String[]{""};
        File file = null;
        try {
            file = Framework.createTempFile((String)"magicdetector", (String)".ppt");
            FileUtils.writeFile((File)file, (byte[])data);
            mimetypes = this.guessPowerpoint(file);
        }
        catch (IOException e) {
            log.error((Object)e, (Throwable)e);
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return mimetypes;
    }

    public String[] process(File file, int offset, int length, long bitmask, char comparator, String mimeType, Map params) {
        return this.guessPowerpoint(file);
    }

    public String[] guessPowerpoint(File file) {
        String[] mimetypes = new String[]{};
        try (FileInputStream stream = new FileInputStream(file);
             HSLFSlideShow ppt = new HSLFSlideShow((InputStream)stream);){
            if (ppt.getSlides().size() != 0) {
                mimetypes = this.getHandledTypes();
            }
        }
        catch (IOException | RuntimeException e) {
            log.debug((Object)"MimeType detector: Not a PowerPoint file", (Throwable)e);
        }
        return mimetypes;
    }
}

