/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.jtajca;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.spi.NamingManager;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.InvalidTransactionException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.LocalTransactions;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.PoolingSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.TransactionSupport;
import org.apache.geronimo.connector.outbound.connectionmanagerconfig.XATransactions;
import org.apache.geronimo.transaction.manager.NamedXAResourceFactory;
import org.apache.geronimo.transaction.manager.RecoverableTransactionManager;
import org.apache.geronimo.transaction.manager.TransactionImpl;
import org.apache.geronimo.transaction.manager.TransactionManagerImpl;
import org.apache.xbean.naming.reference.SimpleReference;
import org.nuxeo.common.logging.SequenceTracer;
import org.nuxeo.common.utils.ExceptionUtils;
import org.nuxeo.runtime.jtajca.InitialContextAccessor;
import org.nuxeo.runtime.jtajca.NamingContext;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManager;
import org.nuxeo.runtime.jtajca.NuxeoConnectionManagerConfiguration;
import org.nuxeo.runtime.jtajca.NuxeoConnectionTrackingCoordinator;
import org.nuxeo.runtime.jtajca.NuxeoContainerListener;
import org.nuxeo.runtime.jtajca.NuxeoPool;
import org.nuxeo.runtime.jtajca.NuxeoTransactionManagerFactory;
import org.nuxeo.runtime.jtajca.NuxeoValidationSupport;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class NuxeoContainer {
    protected static final Log log = LogFactory.getLog(NuxeoContainer.class);
    protected static RecoverableTransactionManager tmRecoverable;
    protected static TransactionManager tm;
    protected static TransactionSynchronizationRegistry tmSynchRegistry;
    protected static UserTransaction ut;
    protected static Map<String, ConnectionManagerWrapper> connectionManagers;
    private static final List<NuxeoContainerListener> listeners;
    private static volatile InstallContext installContext;
    protected static Context rootContext;
    protected static Context parentContext;
    protected static String jndiPrefix;
    protected static final MetricRegistry registry;
    protected static final Counter rollbackCount;
    protected static final Counter concurrentCount;
    protected static final Counter concurrentMaxCount;
    protected static final Timer transactionTimer;
    protected static final ConcurrentHashMap<Transaction, Timer.Context> timers;

    private NuxeoContainer() {
    }

    protected static void install() throws NamingException {
        if (installContext != null) {
            throw new RuntimeException("Nuxeo container already installed");
        }
        installContext = new InstallContext();
        log.trace((Object)"Installing nuxeo container", (Throwable)installContext);
        rootContext = new NamingContext();
        parentContext = InitialContextAccessor.getInitialContext();
        if (parentContext != null && parentContext != rootContext) {
            NuxeoContainer.installTransactionManager(parentContext);
        } else {
            NuxeoContainer.addDeepBinding(NuxeoContainer.nameOf("TransactionManager"), new Reference(TransactionManager.class.getName(), NuxeoTransactionManagerFactory.class.getName(), null));
            NuxeoContainer.installTransactionManager(rootContext);
        }
    }

    protected static void installTransactionManager(TransactionManagerConfiguration config) throws NamingException {
        NuxeoContainer.initTransactionManager(config);
        NuxeoContainer.addDeepBinding(rootContext, new CompositeName(NuxeoContainer.nameOf("TransactionManager")), NuxeoContainer.getTransactionManagerReference());
        NuxeoContainer.addDeepBinding(rootContext, new CompositeName(NuxeoContainer.nameOf("UserTransaction")), NuxeoContainer.getUserTransactionReference());
    }

    public static synchronized ConnectionManagerWrapper installConnectionManager(NuxeoConnectionManagerConfiguration config) {
        String name = config.getName();
        ConnectionManagerWrapper cm = connectionManagers.get(name);
        if (cm != null) {
            return cm;
        }
        cm = NuxeoContainer.initConnectionManager(config);
        if (rootContext != null) {
            String jndiName = NuxeoContainer.nameOf("ConnectionManager/".concat(name));
            try {
                NuxeoContainer.addDeepBinding(rootContext, new CompositeName(jndiName), NuxeoContainer.getConnectionManagerReference(name));
            }
            catch (NamingException e) {
                log.error((Object)("Cannot bind in JNDI connection manager " + config.getName() + " to name " + jndiName));
            }
        }
        return cm;
    }

    public static boolean isInstalled() {
        return installContext != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void uninstall() throws NamingException {
        if (installContext == null) {
            throw new RuntimeException("Nuxeo container not installed");
        }
        try {
            NamingException errors = new NamingException("Cannot shutdown connection managers");
            for (ConnectionManagerWrapper cm : connectionManagers.values()) {
                try {
                    cm.dispose();
                }
                catch (RuntimeException cause) {
                    errors.addSuppressed(cause);
                }
            }
            if (errors.getSuppressed().length > 0) {
                log.error((Object)"Cannot shutdown some pools", (Throwable)errors);
                throw errors;
            }
        }
        finally {
            log.trace((Object)"Uninstalling nuxeo container", (Throwable)installContext);
            installContext = null;
            rootContext = null;
            tm = null;
            tmRecoverable = null;
            tmSynchRegistry = null;
            ut = null;
            connectionManagers.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListener(NuxeoContainerListener listener) {
        List<NuxeoContainerListener> list = listeners;
        synchronized (list) {
            listeners.add(listener);
        }
        for (Map.Entry entry : connectionManagers.entrySet()) {
            listener.handleNewConnectionManager((String)entry.getKey(), ((ConnectionManagerWrapper)entry.getValue()).cm);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeListener(NuxeoContainerListener listener) {
        List<NuxeoContainerListener> list = listeners;
        synchronized (list) {
            listeners.remove(listener);
        }
    }

    protected static String detectJNDIPrefix(Context context) {
        String name = context.getClass().getName();
        if ("org.jnp.interfaces.NamingContext".equals(name)) {
            return "java:";
        }
        if ("org.jboss.as.naming.InitialContext".equals(name)) {
            return "java:jboss/";
        }
        if ("org.mortbay.naming.local.localContextRoot".equals(name)) {
            return "jdbc/";
        }
        return "java:comp/env/";
    }

    public static String nameOf(String name) {
        return jndiPrefix.concat(name);
    }

    public static Context getRootContext() {
        return rootContext;
    }

    public static void addDeepBinding(String name, Object obj) throws NamingException {
        NuxeoContainer.addDeepBinding(rootContext, new CompositeName(name), obj);
    }

    protected static void addDeepBinding(Context dir, CompositeName comp, Object obj) throws NamingException {
        Context subdir;
        Name name = comp.getPrefix(1);
        if (comp.size() == 1) {
            NuxeoContainer.addBinding(dir, name, obj);
            return;
        }
        try {
            subdir = (Context)dir.lookup(name);
        }
        catch (NamingException e) {
            subdir = dir.createSubcontext(name);
        }
        NuxeoContainer.addDeepBinding(subdir, (CompositeName)comp.getSuffix(1), obj);
    }

    protected static void addBinding(Context dir, Name name, Object obj) throws NamingException {
        try {
            dir.rebind(name, obj);
        }
        catch (NamingException e) {
            dir.bind(name, obj);
        }
    }

    protected static void removeBinding(String name) throws NamingException {
        rootContext.unbind(name);
    }

    public static TransactionManager getTransactionManager() {
        return tm;
    }

    protected static Reference getTransactionManagerReference() {
        return new SimpleReference(){
            private static final long serialVersionUID = 1L;

            public Object getContent() throws NamingException {
                return NuxeoContainer.getTransactionManager();
            }
        };
    }

    public static UserTransaction getUserTransaction() {
        return ut;
    }

    protected static Reference getUserTransactionReference() {
        return new SimpleReference(){
            private static final long serialVersionUID = 1L;

            public Object getContent() throws NamingException {
                return NuxeoContainer.getUserTransaction();
            }
        };
    }

    public static NuxeoConnectionManager getConnectionManager(String repositoryName) {
        ConnectionManagerWrapper wrapper = connectionManagers.get(repositoryName);
        if (wrapper == null) {
            return null;
        }
        return wrapper.cm;
    }

    public static void installConnectionManager(ConnectionManagerWrapper wrapper) {
        String name = wrapper.config.getName();
        if (connectionManagers.containsKey(name)) {
            log.error((Object)("Connection manager " + name + " already set up"), (Throwable)new Exception());
        }
        connectionManagers.put(name, wrapper);
        for (NuxeoContainerListener listener : listeners) {
            listener.handleNewConnectionManager(name, wrapper.cm);
        }
    }

    protected static Reference getConnectionManagerReference(final String name) {
        return new SimpleReference(){
            private static final long serialVersionUID = 1L;

            public Object getContent() throws NamingException {
                return NuxeoContainer.getConnectionManager(name);
            }
        };
    }

    protected static synchronized TransactionManager initTransactionManager(TransactionManagerConfiguration config) {
        TransactionManagerImpl impl = NuxeoContainer.createTransactionManager(config);
        tm = impl;
        tmRecoverable = impl;
        tmSynchRegistry = impl;
        ut = new UserTransactionImpl(tm);
        return tm;
    }

    protected static TransactionManagerWrapper wrapTransactionManager(TransactionManager tm) {
        if (tm == null) {
            return null;
        }
        if (tm instanceof TransactionManagerWrapper) {
            return (TransactionManagerWrapper)tm;
        }
        return new TransactionManagerWrapper(tm);
    }

    public static synchronized ConnectionManagerWrapper initConnectionManager(NuxeoConnectionManagerConfiguration config) {
        NuxeoConnectionTrackingCoordinator coordinator = new NuxeoConnectionTrackingCoordinator();
        NuxeoConnectionManager cm = NuxeoContainer.createConnectionManager(coordinator, config);
        ConnectionManagerWrapper cmw = new ConnectionManagerWrapper(coordinator, cm, config);
        NuxeoContainer.installConnectionManager(cmw);
        return cmw;
    }

    public static synchronized void disposeConnectionManager(ConnectionManager mgr) {
        ((ConnectionManagerWrapper)mgr).dispose();
    }

    public static synchronized void resetConnectionManager() {
        RuntimeException errors = new RuntimeException("Cannot reset connection managers");
        for (ConnectionManagerWrapper wrapper : connectionManagers.values()) {
            try {
                wrapper.reset();
            }
            catch (RuntimeException cause) {
                errors.addSuppressed(cause);
            }
        }
        if (errors.getSuppressed().length > 0) {
            throw errors;
        }
    }

    public static synchronized void resetConnectionManager(String name) {
        connectionManagers.get(name).reset();
    }

    public static <T> T lookup(String name, Class<T> type) throws NamingException {
        if (rootContext == null) {
            throw new NamingException("no naming context available");
        }
        return NuxeoContainer.lookup(rootContext, name, type);
    }

    public static <T> T lookup(Context context, String name, Class<T> type) throws NamingException {
        Object resolved;
        try {
            resolved = context.lookup(NuxeoContainer.detectJNDIPrefix(context).concat(name));
        }
        catch (NamingException cause) {
            if (parentContext == null) {
                throw cause;
            }
            return type.cast(parentContext.lookup(NuxeoContainer.detectJNDIPrefix(parentContext).concat(name)));
        }
        if (resolved instanceof Reference) {
            try {
                resolved = NamingManager.getObjectInstance(resolved, new CompositeName(name), rootContext, null);
            }
            catch (NamingException e) {
                throw e;
            }
            catch (Exception e) {
                throw ExceptionUtils.runtimeException((Exception)e);
            }
        }
        return type.cast(resolved);
    }

    protected static void installTransactionManager(Context context) throws NamingException {
        TransactionManager actual = NuxeoContainer.lookup(context, "TransactionManager", TransactionManager.class);
        if (tm != null) {
            return;
        }
        tm = actual;
        tmRecoverable = NuxeoContainer.wrapTransactionManager(tm);
        ut = new UserTransactionImpl(tm);
        tmSynchRegistry = (TransactionSynchronizationRegistry)tm;
    }

    protected static ConnectionManagerWrapper lookupConnectionManager(String repositoryName) throws NamingException {
        ConnectionManager cm = NuxeoContainer.lookup(rootContext, "ConnectionManager/".concat(repositoryName), ConnectionManager.class);
        if (cm instanceof ConnectionManagerWrapper) {
            return (ConnectionManagerWrapper)cm;
        }
        log.warn((Object)"Connection manager not a wrapper, check your configuration");
        throw new RuntimeException("Connection manager of " + repositoryName + " not a wrapper, check your configuration");
    }

    protected static TransactionManagerImpl createTransactionManager(TransactionManagerConfiguration config) {
        if (config == null) {
            config = new TransactionManagerConfiguration();
        }
        try {
            return new TransactionManagerImpl(config.transactionTimeoutSeconds);
        }
        catch (XAException e) {
            throw new RuntimeException(e.toString(), e);
        }
    }

    public static NuxeoConnectionManager createConnectionManager(NuxeoConnectionTrackingCoordinator coordinator, NuxeoConnectionManagerConfiguration config) {
        TransactionSupport transactionSupport = NuxeoContainer.createTransactionSupport(config);
        PoolingSupport poolingSupport = NuxeoContainer.createPoolingSupport(config);
        NuxeoValidationSupport validationSupport = NuxeoContainer.createValidationSupport(config);
        return new NuxeoConnectionManager(config.getActiveTimeoutMinutes() * 60 * 1000, validationSupport, transactionSupport, poolingSupport, null, coordinator, tmRecoverable, config.getName(), Thread.currentThread().getContextClassLoader());
    }

    protected static PoolingSupport createPoolingSupport(NuxeoConnectionManagerConfiguration config) {
        return new NuxeoPool(config);
    }

    protected static TransactionSupport createTransactionSupport(NuxeoConnectionManagerConfiguration config) {
        if (config.getXAMode()) {
            return new XATransactions(config.getUseTransactionCaching(), config.getUseThreadCaching());
        }
        return LocalTransactions.INSTANCE;
    }

    protected static NuxeoValidationSupport createValidationSupport(NuxeoConnectionManagerConfiguration config) {
        return new NuxeoValidationSupport(config.testOnBorrow, config.testOnReturn);
    }

    public static TransactionSynchronizationRegistry getTransactionSynchronizationRegistry() {
        return tmSynchRegistry;
    }

    static {
        connectionManagers = new ConcurrentHashMap<String, ConnectionManagerWrapper>(8, 0.75f, 2);
        listeners = new ArrayList<NuxeoContainerListener>();
        jndiPrefix = "java:comp/env/";
        registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
        rollbackCount = registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "rollbacks"}));
        concurrentCount = registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "concurrents", "count"}));
        concurrentMaxCount = registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "concurrents", "max"}));
        transactionTimer = registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"transactions", "duration"}));
        timers = new ConcurrentHashMap();
    }

    public static class ConnectionManagerWrapper
    implements ConnectionManager {
        private static final long serialVersionUID = 1L;
        protected NuxeoConnectionTrackingCoordinator coordinator;
        protected volatile NuxeoConnectionManager cm;
        protected final NuxeoConnectionManagerConfiguration config;

        public ConnectionManagerWrapper(NuxeoConnectionTrackingCoordinator coordinator, NuxeoConnectionManager cm, NuxeoConnectionManagerConfiguration config) {
            this.coordinator = coordinator;
            this.cm = cm;
            this.config = config;
        }

        public Object allocateConnection(ManagedConnectionFactory managedConnectionFactory, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
            return this.cm.allocateConnection(managedConnectionFactory, connectionRequestInfo);
        }

        public void reset() {
            NuxeoConnectionManager last = this.cm;
            this.cm = NuxeoContainer.createConnectionManager(this.coordinator, this.config);
            try {
                last.doStop();
            }
            catch (Exception e) {
                throw ExceptionUtils.runtimeException((Exception)e);
            }
            for (NuxeoContainerListener listener : listeners) {
                listener.handleConnectionManagerReset(this.config.getName(), this.cm);
            }
        }

        public List<NuxeoConnectionManager.ActiveMonitor.TimeToLive> killActiveTimedoutConnections(long clock) {
            return this.cm.activemonitor.killTimedoutConnections(clock);
        }

        public void dispose() {
            for (NuxeoContainerListener listener : listeners) {
                listener.handleConnectionManagerDispose(this.config.getName(), this.cm);
            }
            this.cm.activemonitor.cancelCleanups();
            connectionManagers.remove(this.config.getName());
            try {
                this.cm.doStop();
            }
            catch (Exception e) {
                throw ExceptionUtils.runtimeException((Exception)e);
            }
        }

        public NuxeoConnectionManagerConfiguration getConfiguration() {
            return this.config;
        }

        public NuxeoConnectionManager getManager() {
            return this.cm;
        }
    }

    public static class TransactionManagerWrapper
    implements RecoverableTransactionManager {
        protected TransactionManager tm;

        public TransactionManagerWrapper(TransactionManager tm) {
            this.tm = tm;
        }

        public Transaction suspend() throws SystemException {
            return this.tm.suspend();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.tm.setTransactionTimeout(seconds);
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.tm.setRollbackOnly();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            this.tm.rollback();
        }

        public void resume(Transaction tobj) throws IllegalStateException, InvalidTransactionException, SystemException {
            this.tm.resume(tobj);
        }

        public int getStatus() throws SystemException {
            return this.tm.getStatus();
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            this.tm.commit();
        }

        public void begin() throws SystemException {
            try {
                this.tm.begin();
            }
            catch (NotSupportedException e) {
                throw new RuntimeException(e);
            }
        }

        public void recoveryError(Exception e) {
            throw new UnsupportedOperationException();
        }

        public void registerNamedXAResourceFactory(NamedXAResourceFactory factory) {
            if (!RecoverableTransactionManager.class.isAssignableFrom(this.tm.getClass())) {
                throw new UnsupportedOperationException();
            }
            ((RecoverableTransactionManager)this.tm).registerNamedXAResourceFactory(factory);
        }

        public void unregisterNamedXAResourceFactory(String factory) {
            if (!RecoverableTransactionManager.class.isAssignableFrom(this.tm.getClass())) {
                throw new UnsupportedOperationException();
            }
            ((RecoverableTransactionManager)this.tm).unregisterNamedXAResourceFactory(factory);
        }

        public Transaction getTransaction() throws SystemException {
            final Transaction tx = this.tm.getTransaction();
            if (tx instanceof TransactionImpl) {
                return tx;
            }
            return new TransactionImpl(null, null){

                public void commit() throws HeuristicMixedException, HeuristicRollbackException, RollbackException, SecurityException, SystemException {
                    tx.commit();
                }

                public void rollback() throws IllegalStateException, SystemException {
                    tx.rollback();
                }

                public synchronized boolean enlistResource(XAResource xaRes) throws IllegalStateException, RollbackException, SystemException {
                    return tx.enlistResource(xaRes);
                }

                public synchronized boolean delistResource(XAResource xaRes, int flag) throws IllegalStateException, SystemException {
                    return super.delistResource(xaRes, flag);
                }

                public synchronized void setRollbackOnly() throws IllegalStateException {
                    try {
                        tx.setRollbackOnly();
                    }
                    catch (SystemException e) {
                        throw new IllegalStateException(e);
                    }
                }

                public void registerInterposedSynchronization(Synchronization synchronization) {
                    try {
                        TransactionHelper.lookupSynchronizationRegistry().registerInterposedSynchronization(synchronization);
                    }
                    catch (NamingException namingException) {
                        // empty catch block
                    }
                }
            };
        }
    }

    public static class TransactionManagerConfiguration {
        public int transactionTimeoutSeconds = 600;

        public void setTransactionTimeoutSeconds(int transactionTimeoutSeconds) {
            this.transactionTimeoutSeconds = transactionTimeoutSeconds;
        }
    }

    public static class UserTransactionImpl
    implements UserTransaction {
        protected final TransactionManager transactionManager;

        public UserTransactionImpl(TransactionManager manager) {
            this.transactionManager = manager;
        }

        public int getStatus() throws SystemException {
            return this.transactionManager.getStatus();
        }

        public void setRollbackOnly() throws IllegalStateException, SystemException {
            this.transactionManager.setRollbackOnly();
        }

        public void setTransactionTimeout(int seconds) throws SystemException {
            this.transactionManager.setTransactionTimeout(seconds);
        }

        public void begin() throws NotSupportedException, SystemException {
            SequenceTracer.start((String)"tx begin", (String)"#DarkSalmon");
            this.transactionManager.begin();
            timers.put(this.transactionManager.getTransaction(), transactionTimer.time());
            concurrentCount.inc();
            if (concurrentCount.getCount() > concurrentMaxCount.getCount()) {
                concurrentMaxCount.inc();
            }
        }

        public void commit() throws HeuristicMixedException, HeuristicRollbackException, IllegalStateException, RollbackException, SecurityException, SystemException {
            SequenceTracer.start((String)"tx commiting", (String)"#de6238");
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                throw new IllegalStateException("No transaction associated with current thread");
            }
            Timer.Context timerContext = timers.remove(transaction);
            this.transactionManager.commit();
            if (timerContext != null) {
                long elapsed = timerContext.stop();
                SequenceTracer.stop((String)"tx commited");
                SequenceTracer.stop((String)("tx end " + elapsed / 1000000L + " ms"));
            }
            concurrentCount.dec();
        }

        public void rollback() throws IllegalStateException, SecurityException, SystemException {
            SequenceTracer.mark((String)"tx rollbacking");
            Transaction transaction = this.transactionManager.getTransaction();
            if (transaction == null) {
                throw new IllegalStateException("No transaction associated with current thread");
            }
            Timer.Context timerContext = timers.remove(transaction);
            this.transactionManager.rollback();
            concurrentCount.dec();
            if (timerContext != null) {
                long elapsed = timerContext.stop();
                SequenceTracer.destroy((String)("tx rollbacked " + elapsed / 1000000L + " ms"));
            }
            rollbackCount.inc();
        }
    }

    public static class InstallContext
    extends Throwable {
        private static final long serialVersionUID = 1L;
        public final String threadName = Thread.currentThread().getName();

        InstallContext() {
            super("Container installation context (" + Thread.currentThread().getName() + ")");
        }
    }
}

