/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.impl.extensions;

import java.util.Calendar;
import org.dom4j.Element;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.ImportExtension;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.storage.lock.LockManagerService;
import org.nuxeo.runtime.api.Framework;

public class DocumentLockImporter
implements ImportExtension {
    @Override
    public void updateImport(CoreSession session, DocumentModel docModel, ExportedDocument xdoc) throws Exception {
        Element lockInfo = xdoc.getDocument().getRootElement().element("lockInfo");
        if (lockInfo != null) {
            String createdMS = lockInfo.element("created").getText();
            String owner = lockInfo.element("owner").getText();
            Calendar created = Calendar.getInstance();
            created.setTimeInMillis(Long.parseLong(createdMS));
            Lock lock = new Lock(owner, created);
            this.getLockManager(session).setLock(docModel.getId(), lock);
        }
    }

    protected LockManager getLockManager(CoreSession session) {
        LockManagerService lms = (LockManagerService)Framework.getService(LockManagerService.class);
        return lms.getLockManager(session.getRepositoryName());
    }
}

