/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.marshallers.json.enrichers;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.io.marshallers.json.enrichers.AbstractJsonEnricher;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.core.trash.TrashService;
import org.nuxeo.runtime.api.Framework;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class FirstAccessibleAncestorJsonEnricher
extends AbstractJsonEnricher<DocumentModel> {
    public static final String NAME = "firstAccessibleAncestor";

    public FirstAccessibleAncestorJsonEnricher() {
        super(NAME);
    }

    @Override
    public void write(JsonGenerator jg, DocumentModel document) throws IOException {
        TrashService trashService = (TrashService)Framework.getService(TrashService.class);
        try (RenderingContext.SessionWrapper wrapper = this.ctx.getSession(document);){
            DocumentModel above = trashService.getAboveDocument(document, wrapper.getSession().getPrincipal());
            if (above != null) {
                this.writeEntityField(NAME, above, jg);
            }
        }
    }
}

