/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.io.registry;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.ws.rs.core.MediaType;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.nuxeo.ecm.core.io.registry.Marshaller;
import org.nuxeo.ecm.core.io.registry.MarshallerRegistry;
import org.nuxeo.ecm.core.io.registry.MarshallingException;
import org.nuxeo.ecm.core.io.registry.Reader;
import org.nuxeo.ecm.core.io.registry.Writer;
import org.nuxeo.ecm.core.io.registry.context.RenderingContext;
import org.nuxeo.runtime.api.Framework;

public final class MarshallerHelper {
    private MarshallerHelper() {
    }

    private static MarshallerRegistry getService() {
        MarshallerRegistry registry = (MarshallerRegistry)Framework.getService(MarshallerRegistry.class);
        return registry;
    }

    private static void checkMarshaller(Type type, Marshaller<?> marshaller) {
        if (marshaller == null) {
            throw new MarshallingException("No marshaller found for type " + type.toString());
        }
    }

    public static <T> String objectToJson(T object, RenderingContext ctx) throws IOException {
        Class<?> type = object.getClass();
        Writer<?> writer = MarshallerHelper.getService().getWriter(ctx, type, MediaType.APPLICATION_JSON_TYPE);
        MarshallerHelper.checkMarshaller(type, writer);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.write(object, type, type, MediaType.APPLICATION_JSON_TYPE, baos);
        return baos.toString();
    }

    public static <T> String objectToJson(Type genericType, T object, RenderingContext ctx) throws IOException {
        Class<?> type = object.getClass();
        Writer<?> writer = MarshallerHelper.getService().getWriter(ctx, type, genericType, MediaType.APPLICATION_JSON_TYPE);
        MarshallerHelper.checkMarshaller(genericType, writer);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.write(object, type, genericType, MediaType.APPLICATION_JSON_TYPE, baos);
        return baos.toString();
    }

    public static <T> String listToJson(Class<T> elementType, List<T> list, RenderingContext ctx) throws IOException {
        ParameterizedType genericType = TypeUtils.parameterize(List.class, (Type[])new Type[]{elementType});
        Writer<List> writer = MarshallerHelper.getService().getWriter(ctx, List.class, genericType, MediaType.APPLICATION_JSON_TYPE);
        MarshallerHelper.checkMarshaller(genericType, writer);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        writer.write(list, List.class, genericType, MediaType.APPLICATION_JSON_TYPE, baos);
        return baos.toString();
    }

    public static <T> T objectToJson(Class<T> type, String json, RenderingContext ctx) throws IOException {
        Reader<T> reader = MarshallerHelper.getService().getReader(ctx, type, MediaType.APPLICATION_JSON_TYPE);
        MarshallerHelper.checkMarshaller(type, reader);
        return reader.read(type, type, MediaType.APPLICATION_JSON_TYPE, new ByteArrayInputStream(json.getBytes()));
    }

    public static <T> T objectToJson(Class<T> type, Type genericType, String json, RenderingContext ctx) throws IOException {
        Reader<T> reader = MarshallerHelper.getService().getReader(ctx, type, genericType, MediaType.APPLICATION_JSON_TYPE);
        MarshallerHelper.checkMarshaller(genericType, reader);
        return reader.read(type, genericType, MediaType.APPLICATION_JSON_TYPE, new ByteArrayInputStream(json.getBytes()));
    }

    public static <T> List<T> listToJson(Class<T> elementType, String json, RenderingContext ctx) throws IOException {
        ParameterizedType genericType = TypeUtils.parameterize(List.class, (Type[])new Type[]{elementType});
        Reader<List> reader = MarshallerHelper.getService().getReader(ctx, List.class, genericType, MediaType.APPLICATION_JSON_TYPE);
        MarshallerHelper.checkMarshaller(genericType, reader);
        return reader.read(List.class, genericType, MediaType.APPLICATION_JSON_TYPE, new ByteArrayInputStream(json.getBytes()));
    }
}

