/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.kafka;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.lib.stream.log.kafka.KafkaUtils;
import org.nuxeo.runtime.kafka.KafkaConfigDescriptor;
import org.nuxeo.runtime.kafka.KafkaConfigService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class KafkaConfigServiceImpl
extends DefaultComponent
implements KafkaConfigService {
    public static final String KAFKA_CONFIG_XP = "kafkaConfig";
    public static final int APPLICATION_STARTED_ORDER = -600;
    private static final Log log = LogFactory.getLog(KafkaConfigServiceImpl.class);
    protected static final String DEFAULT_ZK_SERVERS = "DEFAULT_TEST";
    protected static final String DEFAULT_BOOTSTRAP_SERVERS = "DEFAULT_TEST";
    protected final Map<String, KafkaConfigDescriptor> configs = new HashMap<String, KafkaConfigDescriptor>();

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (extensionPoint.equals(KAFKA_CONFIG_XP)) {
            KafkaConfigDescriptor descriptor = (KafkaConfigDescriptor)contribution;
            this.configs.put(descriptor.name, descriptor);
            log.info((Object)String.format("Register Kafka contribution: %s", descriptor.name));
        }
    }

    public int getApplicationStartedOrder() {
        return -600;
    }

    public void deactivate(ComponentContext context) {
        super.deactivate(context);
        log.debug((Object)"Deactivating service");
    }

    public void activate(ComponentContext context) {
        super.activate(context);
        log.debug((Object)"Activating service");
    }

    @Override
    public Set<String> listConfigNames() {
        return this.configs.keySet();
    }

    @Override
    public String getZkServers(String configName) {
        this.checkConfigName(configName);
        String ret = this.configs.get((Object)configName).zkServers;
        if ("DEFAULT_TEST".equals(ret)) {
            return KafkaUtils.getZkServers();
        }
        return ret;
    }

    protected void checkConfigName(String configName) {
        if (!this.configs.containsKey(configName)) {
            throw new IllegalArgumentException("Unknown configuration name: " + configName);
        }
    }

    @Override
    public Properties getProducerProperties(String configName) {
        this.checkConfigName(configName);
        Properties ret = this.configs.get(configName).getProducerProperties();
        if ("DEFAULT_TEST".equals(ret.get("bootstrap.servers"))) {
            ret.put("bootstrap.servers", KafkaUtils.getBootstrapServers());
        }
        return ret;
    }

    @Override
    public Properties getConsumerProperties(String configName) {
        this.checkConfigName(configName);
        Properties ret = this.configs.get(configName).getConsumerProperties();
        if ("DEFAULT_TEST".equals(ret.get("bootstrap.servers"))) {
            ret.put("bootstrap.servers", KafkaUtils.getBootstrapServers());
        }
        return ret;
    }

    @Override
    public String getTopicPrefix(String configName) {
        this.checkConfigName(configName);
        return this.configs.get(configName).getTopicPrefix();
    }
}

