/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.common.logging;

import java.lang.reflect.Field;
import org.apache.log4j.LogManager;
import org.apache.log4j.helpers.FileWatchdog;
import org.apache.log4j.xml.DOMConfigurator;
import org.nuxeo.common.logging.Log4jWatchdogHandle;

class Log4jWatchdog
extends FileWatchdog
implements Log4jWatchdogHandle {
    protected Log4jWatchdog(String filename) {
        super(filename);
        this.setName("Nuxeo Log4J Watchdog");
    }

    protected void doOnChange() {
        this.configure();
    }

    protected void configure() {
        new DOMConfigurator().doConfigure(this.filename, LogManager.getLoggerRepository());
    }

    @Override
    public void cancel() {
        try {
            Field field = FileWatchdog.class.getDeclaredField("interrupted");
            field.setAccessible(true);
            field.set(this, true);
        }
        catch (ReflectiveOperationException cause) {
            throw new RuntimeException("Cannot cancel log4j watchdog", cause);
        }
    }

    public static Log4jWatchdogHandle watch(String filename, long delay) {
        Log4jWatchdog wdog = new Log4jWatchdog(filename);
        wdog.setDelay(delay);
        wdog.start();
        return wdog;
    }
}

