/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.filter;

import com.thetransactioncompany.cors.CORSConfiguration;
import com.thetransactioncompany.cors.CORSFilter;
import com.thetransactioncompany.cors.Origin;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.web.common.requestcontroller.service.RequestControllerManager;
import org.nuxeo.ecm.platform.web.common.vh.VirtualHostHelper;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCorsCsrfFilter
implements Filter {
    private static final Log log = LogFactory.getLog(NuxeoCorsCsrfFilter.class);
    public static final String GET = "GET";
    public static final String HEAD = "HEAD";
    public static final String OPTIONS = "OPTIONS";
    public static final String TRACE = "TRACE";

    public void init(FilterConfig filterConfig) {
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
        boolean allow;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        RequestControllerManager service = (RequestControllerManager)Framework.getService(RequestControllerManager.class);
        CORSFilter corsFilter = service.getCorsFilterForRequest(request);
        CORSConfiguration corsConfig = corsFilter == null ? null : corsFilter.getConfiguration();
        String method = request.getMethod();
        URI sourceURI = this.getSourceURI(request);
        URI targetURI = this.getTargetURI(request);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Method: " + method + ", source: " + sourceURI + ", target: " + targetURI));
        }
        if (GET.equals(method) || HEAD.equals(method) || OPTIONS.equals(method) || TRACE.equals(method)) {
            log.debug((Object)"Safe method: allow");
            allow = true;
        } else if (this.sourceAndTargetMatch(sourceURI, targetURI)) {
            log.debug((Object)"Source and target match: allow");
            if (targetURI == null) {
                log.error((Object)"Cannot determine target URL for CSRF check");
            }
            allow = true;
        } else if (corsConfig == null) {
            log.debug((Object)"URL not covered by CORS config: disallow cross-site request");
            allow = false;
        } else if (!corsConfig.isAllowedOrigin(new Origin(sourceURI.toString()))) {
            log.debug((Object)"Origin not allowed by CORS config: disallow cross-site request");
            allow = false;
        } else if (!corsConfig.isSupportedMethod(method)) {
            log.debug((Object)"Method not allowed by CORS config: disallow cross-site request");
            allow = false;
        } else {
            log.debug((Object)"Origin and method allowed by CORS config: allow cross-site request");
            allow = true;
        }
        if (allow) {
            if (corsFilter == null) {
                chain.doFilter((ServletRequest)request, (ServletResponse)response);
            } else {
                corsFilter.doFilter((ServletRequest)request, (ServletResponse)response, chain);
            }
            return;
        }
        String message = "CSRF check failure";
        log.warn((Object)(message + ": source: " + sourceURI + " does not match target: " + targetURI + " and not allowed by CORS config"));
        response.sendError(403, message);
    }

    public URI getSourceURI(HttpServletRequest request) {
        String source = request.getHeader("Origin");
        if (StringUtils.isBlank((CharSequence)source)) {
            source = request.getHeader("Referer");
        }
        if (StringUtils.isBlank((CharSequence)source)) {
            return null;
        }
        if ("null".equals(source = source.trim())) {
            return null;
        }
        if (source.contains(" ")) {
            source = source.substring(0, source.indexOf(32));
        }
        try {
            return new URI(source);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public URI getTargetURI(HttpServletRequest request) {
        String baseURL = VirtualHostHelper.getServerURL((ServletRequest)request, false);
        if (baseURL == null) {
            return null;
        }
        try {
            return new URI(baseURL);
        }
        catch (URISyntaxException e) {
            return null;
        }
    }

    public boolean sourceAndTargetMatch(URI sourceURI, URI targetURI) {
        if (sourceURI == null || targetURI == null) {
            return true;
        }
        return Objects.equals(sourceURI.getScheme(), targetURI.getScheme()) && Objects.equals(sourceURI.getHost(), targetURI.getHost()) && sourceURI.getPort() == targetURI.getPort();
    }
}

