/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.web.common.requestcontroller.service;

import com.thetransactioncompany.cors.CORSFilter;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Pattern;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.runtime.api.Framework;

@XObject(value="corsConfig")
public class NuxeoCorsFilterDescriptor
implements Serializable,
Cloneable {
    private static final String PROPERTIES_PREFIX = "cors.";
    @XNode(value="@name")
    protected String name;
    @XNode(value="@enabled")
    protected Boolean enabled = true;
    @XNode(value="@allowGenericHttpRequests")
    protected Boolean allowGenericHttpRequests = true;
    @XNode(value="@allowOrigin")
    protected String allowOrigin;
    @XNode(value="@allowSubdomains")
    protected boolean allowSubdomains = false;
    @XNode(value="@supportedMethods")
    protected String supportedMethods;
    @XNode(value="@supportedHeaders")
    protected String supportedHeaders;
    @XNode(value="@exposedHeaders")
    protected String exposedHeaders;
    @XNode(value="@supportsCredentials")
    protected Boolean supportsCredentials = true;
    @XNode(value="@maxAge")
    protected int maxAge = -1;
    protected Pattern pattern;
    protected volatile CORSFilter filter;

    @XNode(value="pattern")
    public void setPattern(String patternString) {
        if (!StringUtils.isBlank((CharSequence)(patternString = Framework.expandVars((String)patternString)))) {
            this.pattern = Pattern.compile(patternString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CORSFilter getFilter() {
        if (this.filter == null) {
            NuxeoCorsFilterDescriptor nuxeoCorsFilterDescriptor = this;
            synchronized (nuxeoCorsFilterDescriptor) {
                if (this.filter == null) {
                    CORSFilter corsFilter = new CORSFilter();
                    try {
                        corsFilter.init(this.buildFilterConfig());
                    }
                    catch (ServletException e) {
                        throw new NuxeoException((Throwable)e);
                    }
                    this.filter = corsFilter;
                }
            }
        }
        return this.filter;
    }

    protected FilterConfig buildFilterConfig() {
        final Dictionary<String, String> parameters = this.buildDictionary();
        return new FilterConfig(){

            public String getFilterName() {
                return "NuxeoCorsFilterDescriptor";
            }

            public ServletContext getServletContext() {
                return null;
            }

            public String getInitParameter(String name) {
                return (String)parameters.get(name);
            }

            public Enumeration getInitParameterNames() {
                return parameters.keys();
            }
        };
    }

    public NuxeoCorsFilterDescriptor clone() throws CloneNotSupportedException {
        NuxeoCorsFilterDescriptor n = new NuxeoCorsFilterDescriptor();
        n.name = this.name;
        n.allowGenericHttpRequests = this.allowGenericHttpRequests;
        n.allowOrigin = this.allowOrigin;
        n.allowSubdomains = this.allowSubdomains;
        n.supportedMethods = this.supportedMethods;
        n.supportedHeaders = this.supportedHeaders;
        n.exposedHeaders = this.exposedHeaders;
        n.supportsCredentials = this.supportsCredentials;
        n.maxAge = this.maxAge;
        n.pattern = this.pattern;
        return n;
    }

    public void merge(NuxeoCorsFilterDescriptor o) {
        this.allowGenericHttpRequests = o.allowGenericHttpRequests;
        this.supportsCredentials = o.supportsCredentials;
        this.allowSubdomains = o.allowSubdomains;
        if (!StringUtils.isEmpty((CharSequence)o.allowOrigin)) {
            this.allowOrigin = o.allowOrigin;
        }
        if (!StringUtils.isEmpty((CharSequence)o.supportedMethods)) {
            this.supportedMethods = o.supportedMethods;
        }
        if (!StringUtils.isEmpty((CharSequence)o.supportedHeaders)) {
            this.supportedHeaders = o.supportedHeaders;
        }
        if (!StringUtils.isEmpty((CharSequence)o.exposedHeaders)) {
            this.exposedHeaders = o.exposedHeaders;
        }
        if (this.maxAge == -1) {
            this.maxAge = o.maxAge;
        }
        if (o.pattern != null) {
            this.pattern = o.pattern;
        }
        this.filter = null;
    }

    protected Dictionary<String, String> buildDictionary() {
        Hashtable<String, String> params = new Hashtable<String, String>();
        ((Dictionary)params).put("cors.allowGenericHttpRequests", Boolean.toString(this.allowGenericHttpRequests));
        if (!StringUtils.isEmpty((CharSequence)this.allowOrigin)) {
            ((Dictionary)params).put("cors.allowOrigin", this.allowOrigin);
        }
        ((Dictionary)params).put("cors.allowSubdomains", Boolean.toString(this.allowSubdomains));
        if (!StringUtils.isEmpty((CharSequence)this.supportedMethods)) {
            ((Dictionary)params).put("cors.supportedMethods", this.supportedMethods);
        }
        if (!StringUtils.isEmpty((CharSequence)this.supportedHeaders)) {
            ((Dictionary)params).put("cors.supportedHeaders", this.supportedHeaders);
        }
        if (!StringUtils.isEmpty((CharSequence)this.exposedHeaders)) {
            ((Dictionary)params).put("cors.exposedHeaders", this.exposedHeaders);
        }
        ((Dictionary)params).put("cors.supportsCredentials", Boolean.toString(this.supportsCredentials));
        ((Dictionary)params).put("cors.maxAge", Integer.toString(this.maxAge));
        return params;
    }
}

