/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.dublincore.service;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SystemPrincipal;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.DefaultComponent;

public class DublinCoreStorageService
extends DefaultComponent {
    public static final String ID = "DublinCoreStorageService";

    public void setCreationDate(DocumentModel doc, Calendar creationDate, Event event) {
        doc.setProperty("dublincore", "created", (Object)creationDate);
        this.addContributor(doc, event);
    }

    public void setModificationDate(DocumentModel doc, Calendar modificationDate, Event event) {
        doc.setProperty("dublincore", "modified", (Object)modificationDate);
        if (doc.getProperty("dublincore", "created") == null) {
            this.setCreationDate(doc, modificationDate, event);
        }
    }

    public void addContributor(DocumentModel doc, Event event) {
        Principal principal = event.getContext().getPrincipal();
        if (principal == null) {
            return;
        }
        String principalName = principal.getName();
        if (principal instanceof SystemPrincipal) {
            SystemPrincipal nxp = (SystemPrincipal)principal;
            String originatingUser = nxp.getOriginatingUser();
            if ((originatingUser == null || "system".equals(originatingUser)) && !"documentCreated".equals(event.getName())) {
                return;
            }
            principalName = originatingUser;
        }
        String[] contributorsArray = (String[])doc.getProperty("dublincore", "contributors");
        List<Object> contributorsList = new ArrayList();
        if (contributorsArray != null && contributorsArray.length > 0) {
            contributorsList = Arrays.asList(contributorsArray);
            contributorsList = new ArrayList(contributorsList);
        } else {
            SchemaManager schemaMgr = (SchemaManager)Framework.getService(SchemaManager.class);
            if (schemaMgr.getSchema("dublincore").getField("creator") != null) {
                doc.setProperty("dublincore", "creator", (Object)principalName);
            }
        }
        if (!contributorsList.contains(principalName)) {
            contributorsList.add(principalName);
            String[] contributorListIn = new String[contributorsList.size()];
            contributorsList.toArray(contributorListIn);
            doc.setProperty("dublincore", "contributors", (Object)contributorListIn);
        }
        doc.setProperty("dublincore", "lastContributor", (Object)principalName);
    }

    public void setIssuedDate(DocumentModel doc, Calendar issuedDate) {
        doc.setPropertyValue("dc:issued", (Serializable)issuedDate);
    }
}

