/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.memory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.memory.MemoryDirectory;

public class MemoryDirectorySession
extends BaseSession {
    protected final Map<String, Map<String, Object>> data = Collections.synchronizedMap(new LinkedHashMap());

    public MemoryDirectorySession(MemoryDirectory directory) {
        super((Directory)directory, null);
    }

    public MemoryDirectory getDirectory() {
        return (MemoryDirectory)this.directory;
    }

    public boolean authenticate(String username, String password) throws DirectoryException {
        Map<String, Object> map = this.data.get(username);
        if (map == null) {
            return false;
        }
        String expected = (String)map.get(this.getPasswordField());
        if (expected == null) {
            return false;
        }
        return expected.equals(password);
    }

    public void close() {
    }

    public void commit() {
    }

    public void rollback() throws DirectoryException {
        throw new RuntimeException("Not implemented");
    }

    public DocumentModel createEntryWithoutReferences(Map<String, Object> fieldMap) throws DirectoryException {
        Object rawId = fieldMap.get(this.getIdField());
        if (rawId == null) {
            throw new DirectoryException("Missing id");
        }
        String id = String.valueOf(rawId);
        Map<String, Object> map = this.data.get(id);
        if (map != null) {
            throw new DirectoryException(String.format("Entry with id %s already exists", id));
        }
        map = new HashMap<String, Object>();
        this.data.put(id, map);
        for (Map.Entry<String, Object> e : fieldMap.entrySet()) {
            String fieldName = e.getKey();
            if (!this.getDirectory().schemaSet.contains(fieldName)) continue;
            map.put(fieldName, e.getValue());
        }
        return this.getEntry(id);
    }

    protected List<String> updateEntryWithoutReferences(DocumentModel docModel) throws DirectoryException {
        String id = docModel.getId();
        DataModel dataModel = docModel.getDataModel(this.directory.getSchema());
        Map<String, Object> map = this.data.get(id);
        if (map == null) {
            throw new DirectoryException("UpdateEntry failed: entry '" + id + "' not found");
        }
        for (String fieldName : this.getDirectory().schemaSet) {
            try {
                if (!dataModel.isDirty(fieldName)) continue;
                if (fieldName.equals(this.getIdField())) {
                }
            }
            catch (PropertyNotFoundException e) {}
            continue;
            map.put(fieldName, dataModel.getData(fieldName));
        }
        dataModel.getDirtyFields().clear();
        return new ArrayList<String>();
    }

    protected void deleteEntryWithoutReferences(String id) throws DirectoryException {
        this.checkDeleteConstraints(id);
        this.data.remove(id);
    }

    public DocumentModel createEntry(Map<String, Object> fieldMap) throws DirectoryException {
        this.checkPermission("Write");
        return this.createEntryWithoutReferences(fieldMap);
    }

    public void updateEntry(DocumentModel docModel) throws DirectoryException {
        this.checkPermission("Write");
        this.updateEntryWithoutReferences(docModel);
    }

    public void deleteEntry(String id) throws DirectoryException {
        this.checkPermission("Write");
        this.deleteEntryWithoutReferences(id);
    }

    public DocumentModel getEntry(String id, boolean fetchReferences) throws DirectoryException {
        Map<String, Object> map = this.data.get(id);
        if (map == null) {
            return null;
        }
        try {
            return MemoryDirectorySession.createEntryModel(null, (String)this.directory.getSchema(), (String)id, map, (boolean)this.isReadOnly());
        }
        catch (PropertyException e) {
            throw new DirectoryException((Throwable)e);
        }
    }

    public DocumentModelList getEntries() throws DirectoryException {
        DocumentModelListImpl list = new DocumentModelListImpl();
        for (String id : this.data.keySet()) {
            list.add((Object)this.getEntry(id));
        }
        return list;
    }

    public void deleteEntry(String id, Map<String, String> map) throws DirectoryException {
        throw new DirectoryException("Not implemented");
    }

    public void deleteEntry(DocumentModel docModel) throws DirectoryException {
        this.deleteEntry(docModel.getId());
    }

    public DocumentModelList query(Map<String, Serializable> filter, Set<String> fulltext, Map<String, String> orderBy, boolean fetchReferences, int limit, int offset) throws DirectoryException {
        DocumentModelListImpl results = new DocumentModelListImpl();
        HashMap<String, Serializable> filt = new HashMap<String, Serializable>();
        for (Map.Entry<String, Serializable> entry : filter.entrySet()) {
            String fieldName = entry.getKey();
            if (!this.getDirectory().schemaSet.contains(fieldName)) continue;
            filt.put(fieldName, entry.getValue());
        }
        block1: for (Map.Entry<String, Object> entry : this.data.entrySet()) {
            String id = entry.getKey();
            Map map = (Map)entry.getValue();
            for (Map.Entry e : filt.entrySet()) {
                String fieldName = (String)e.getKey();
                Object expected = e.getValue();
                Object value = map.get(fieldName);
                if (!(value == null ? expected != null : (fulltext != null && fulltext.contains(fieldName) ? !value.toString().toLowerCase().startsWith(expected.toString().toLowerCase()) : !value.equals(expected)))) continue;
                continue block1;
            }
            results.add((Object)this.getEntry(id));
        }
        if (orderBy != null && !orderBy.isEmpty()) {
            this.getDirectory().orderEntries((List<DocumentModel>)results, orderBy);
        }
        return this.applyQueryLimits((DocumentModelList)results, limit, offset);
    }

    public DocumentModel createEntry(DocumentModel entry) {
        Map fieldMap = entry.getProperties(this.directory.getSchema());
        return this.createEntry(fieldMap);
    }

    public boolean hasEntry(String id) {
        return this.data.containsKey(id);
    }
}

