/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationParameters;

public class OperationChain
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final String id;
    protected final List<OperationParameters> operations = new ArrayList<OperationParameters>();
    protected final Map<String, Object> chainParameters = new HashMap<String, Object>();
    protected String description;
    protected String[] aliases;
    protected boolean isPublic;

    public OperationChain(String id) {
        this(id, Collections.emptyList());
    }

    public OperationChain(String id, List<OperationParameters> operations) {
        this(id, operations, Collections.emptyMap());
    }

    public OperationChain(String id, List<OperationParameters> operations, Map<String, Object> chainParameters) {
        this.id = id;
        this.operations.addAll(operations);
        this.chainParameters.putAll(chainParameters);
    }

    public String getId() {
        return this.id;
    }

    public String[] getAliases() {
        return this.aliases;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAliases(String[] aliases) {
        this.aliases = aliases;
    }

    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    public List<OperationParameters> getOperations() {
        return this.operations;
    }

    public void add(OperationParameters op) {
        this.operations.add(op);
    }

    public OperationParameters add(String operationId) {
        OperationParameters op = new OperationParameters(operationId);
        this.operations.add(op);
        return op;
    }

    public void addChainParameters(Map<String, ?> chainParameter) {
        if (chainParameter == null) {
            LogFactory.getLog(OperationChain.class).warn((Object)("null parameters given to " + this.id), new Throwable("stack trace"));
            return;
        }
        this.chainParameters.putAll(chainParameter);
    }

    public Map<String, ?> getChainParameters() {
        return this.chainParameters;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id.hashCode();
        result = 31 * result + this.chainParameters.hashCode();
        result = 31 * result + this.operations.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OperationChain)) {
            return false;
        }
        OperationChain other = (OperationChain)obj;
        if (!this.id.equals(other.id)) {
            return false;
        }
        if (!this.chainParameters.equals(other.chainParameters)) {
            return false;
        }
        return this.operations.equals(other.operations);
    }

    public String toString() {
        return "OperationChain [id=" + this.id + "]";
    }
}

