/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation;

import java.security.Principal;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nuxeo.ecm.automation.CleanupHandler;
import org.nuxeo.ecm.automation.LoginStack;
import org.nuxeo.ecm.automation.OperationCallback;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class OperationContext
extends AbstractMap<String, Object>
implements AutoCloseable {
    protected boolean commit = true;
    protected final transient List<CleanupHandler> cleanupHandlers;
    protected final Map<String, Object> vars;
    protected final transient Map<String, Deque<Object>> stacks = new HashMap<String, Deque<Object>>();
    protected transient LoginStack loginStack;
    protected Object input;
    protected List<String> trace;
    protected OperationCallback callback;

    public OperationContext() {
        this(null);
    }

    public OperationContext(CoreSession session) {
        this(session, new HashMap<String, Object>());
    }

    protected OperationContext(CoreSession session, Map<String, Object> bindings) {
        this.vars = bindings;
        this.cleanupHandlers = new ArrayList<CleanupHandler>();
        this.loginStack = new LoginStack(session);
        this.trace = new ArrayList<String>();
        this.callback = ((TracerFactory)Framework.getService(TracerFactory.class)).newTracer();
    }

    public void setCoreSession(CoreSession session) {
        this.loginStack.setSession(session);
    }

    public void setCommit(boolean commit) {
        this.commit = commit;
    }

    public boolean isCommit() {
        return this.commit;
    }

    public CoreSession getCoreSession() {
        return this.loginStack.getSession();
    }

    public LoginStack getLoginStack() {
        return this.loginStack;
    }

    public Principal getPrincipal() {
        CoreSession session = this.loginStack.getSession();
        return session != null ? session.getPrincipal() : null;
    }

    public void setInput(Object input) {
        this.input = input;
    }

    public Object getInput() {
        return this.input;
    }

    public void push(Map<String, ?> map) {
        map.forEach(this::push);
    }

    public void pop(Map<String, ?> map) {
        map.forEach((k, v) -> this.pop((String)k));
    }

    public Object push(String type, Object obj) {
        Deque<Object> stack = this.stacks.get(type);
        if (stack == null) {
            if (this.vars.containsKey(type)) {
                throw new IllegalStateException(type + " is not a stack");
            }
            stack = new LinkedList<Object>();
            this.stacks.put(type, stack);
        }
        Object current = stack.peek();
        stack.push(obj);
        this.vars.put(type, obj);
        return current;
    }

    public Object peek(String type) {
        return this.vars.get(type);
    }

    public Object pop(String type) {
        Deque<Object> stack = this.stacks.get(type);
        if (stack == null) {
            return null;
        }
        this.vars.remove(type);
        Object obj = stack.pop();
        if (stack.isEmpty()) {
            this.stacks.remove(type);
        }
        return obj;
    }

    public Object pull(String type) {
        Deque<Object> stack = this.stacks.get(type);
        if (stack == null) {
            return null;
        }
        Object obj = stack.removeLast();
        if (stack.isEmpty()) {
            this.vars.remove(type);
            this.stacks.remove(type);
        }
        return obj;
    }

    public <T> T getAdapter(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return type.cast(this);
        }
        if (type.isAssignableFrom(CoreSession.class)) {
            return type.cast(this.getCoreSession());
        }
        if (type.isAssignableFrom(Principal.class)) {
            return type.cast(this.getPrincipal());
        }
        return (T)Framework.getService(type);
    }

    public void addCleanupHandler(CleanupHandler handler) {
        this.cleanupHandlers.add(handler);
    }

    public void removeCleanupHandler(CleanupHandler handler) {
        this.cleanupHandlers.remove(handler);
    }

    @Override
    public void close() {
        if (this.getCoreSession() != null && this.isCommit()) {
            this.getCoreSession().save();
        }
        this.trace.clear();
        this.loginStack.clear();
        this.cleanupHandlers.forEach(CleanupHandler::cleanup);
    }

    public void setRollback() {
        this.setCommit(false);
        TransactionHelper.setTransactionRollbackOnly();
    }

    public Map<String, Object> getVars() {
        return this.vars;
    }

    @Override
    public boolean containsKey(Object key) {
        if ("ChainParameters".equals(key)) {
            return true;
        }
        return super.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        if ("ChainParameters".equals(key)) {
            return this;
        }
        return this.resolve(this.vars.get(key));
    }

    @Override
    public Object put(String key, Object value) {
        if ("ChainParameters".equals(key)) {
            throw new IllegalArgumentException("ChainParameters is reserved, not writable");
        }
        return this.resolve(this.vars.put(key, value));
    }

    @Override
    public Object remove(Object key) {
        if ("ChainParameters".equals(key)) {
            throw new IllegalArgumentException("ChainParameters is reserved, not writable");
        }
        return this.resolve(this.vars.remove(key));
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return new AbstractSet<Map.Entry<String, Object>>(){

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                final Iterator<Map.Entry<String, Object>> iterator = OperationContext.this.vars.entrySet().iterator();
                return new Iterator<Map.Entry<String, Object>>(){

                    @Override
                    public boolean hasNext() {
                        return iterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        final Map.Entry entry = (Map.Entry)iterator.next();
                        return new Map.Entry<String, Object>(){

                            @Override
                            public String getKey() {
                                return (String)entry.getKey();
                            }

                            @Override
                            public Object getValue() {
                                return OperationContext.this.resolve(entry.getValue());
                            }

                            @Override
                            public Object setValue(Object value) {
                                Object previous = entry.setValue(value);
                                return OperationContext.this.resolve(previous);
                            }
                        };
                    }
                };
            }

            @Override
            public int size() {
                return OperationContext.this.vars.size();
            }
        };
    }

    public OperationCallback getCallback() {
        return this.callback;
    }

    public void setCallback(OperationCallback chainCallback) {
        this.callback = chainCallback;
    }

    public OperationContext getSubContext(boolean isolate, Object input) {
        Map<String, Object> vars = isolate ? new HashMap<String, Object>(this.getVars()) : this.getVars();
        OperationContext subctx = new OperationContext(this.getCoreSession(), vars);
        subctx.setInput(input);
        subctx.setCallback(this.callback);
        return subctx;
    }

    public OperationContext getSubContext(boolean isolate) {
        return this.getSubContext(isolate, this.getInput());
    }

    public Object resolve(Object obj) {
        if (!(obj instanceof Expression)) {
            return obj;
        }
        return ((Expression)obj).eval(this);
    }
}

