/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;

public class InvokableMethod
implements Comparable<InvokableMethod> {
    protected static final Log log = LogFactory.getLog(InvokableMethod.class);
    public static final int VOID_PRIORITY = 1;
    public static final int ADAPTABLE_PRIORITY = 2;
    public static final int ISTANCE_OF_PRIORITY = 3;
    public static final int EXACT_MATCH_PRIORITY = 4;
    public static final int USER_PRIORITY = 16;
    protected OperationType op;
    protected Method method;
    protected Class<?> produce;
    protected Class<?> consume;
    protected int priority;

    public InvokableMethod(OperationType op, Method method, OperationMethod anno) {
        this.produce = method.getReturnType();
        Class<?>[] p = method.getParameterTypes();
        if (p.length > 1) {
            throw new IllegalArgumentException("Operation method must accept at most one argument: " + method);
        }
        this.op = op;
        this.method = method;
        this.priority = anno.priority();
        if (this.priority > 0) {
            this.priority += 16;
        }
        this.consume = p.length == 0 ? Void.TYPE : p[0];
    }

    public InvokableMethod(OperationType op, Method method) {
        this.produce = method.getReturnType();
        Class<?>[] p = method.getParameterTypes();
        if (p.length > 1) {
            throw new IllegalArgumentException("Operation method must accept at most one argument: " + method);
        }
        this.op = op;
        this.method = method;
        String inputType = this.op.getInputType();
        if (inputType != null) {
            switch (inputType) {
                case "document": {
                    this.consume = DocumentModel.class;
                    break;
                }
                case "documents": {
                    this.consume = DocumentModelList.class;
                    break;
                }
                case "blob": {
                    this.consume = Blob.class;
                    break;
                }
                case "blobs": {
                    this.consume = Blobs.class;
                    break;
                }
                default: {
                    this.consume = Object.class;
                    break;
                }
            }
        } else {
            this.consume = p.length == 0 ? Void.TYPE : p[0];
        }
    }

    public boolean isIterable() {
        return false;
    }

    public int getPriority() {
        return this.priority;
    }

    public OperationType getOperation() {
        return this.op;
    }

    public final Class<?> getOutputType() {
        return this.produce;
    }

    public final Class<?> getInputType() {
        return this.consume;
    }

    public int inputMatch(Class<?> in) {
        if (this.consume == in) {
            return this.priority > 0 ? this.priority : 4;
        }
        if (this.consume.isAssignableFrom(in)) {
            return this.priority > 0 ? this.priority : 3;
        }
        if (this.op.getService().isTypeAdaptable(in, this.consume)) {
            return this.priority > 0 ? this.priority : 2;
        }
        if (this.consume == Void.TYPE) {
            return this.priority > 0 ? this.priority : 1;
        }
        return 0;
    }

    protected Object doInvoke(OperationContext ctx, Map<String, Object> args) throws OperationException, ReflectiveOperationException {
        Object target = this.op.newInstance(ctx, args);
        Object input = ctx.getInput();
        if (this.consume == Void.TYPE) {
            Object out = this.method.invoke(target, new Object[0]);
            return this.produce == Void.TYPE ? input : out;
        }
        if (input == null || !this.consume.isAssignableFrom(input.getClass())) {
            input = this.op.getService().getAdaptedValue(ctx, input, this.consume);
        }
        return this.method.invoke(target, input);
    }

    public Object invoke(OperationContext ctx, Map<String, Object> args) throws OperationException {
        try {
            return this.doInvoke(ctx, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof OperationException) {
                throw (OperationException)t;
            }
            if (t instanceof NuxeoException) {
                NuxeoException nuxeoException = (NuxeoException)t;
                nuxeoException.addInfo(this.getExceptionMessage());
                throw nuxeoException;
            }
            throw new OperationException(this.getExceptionMessage(), t);
        }
        catch (ReflectiveOperationException e) {
            throw new OperationException(this.getExceptionMessage(), e);
        }
    }

    protected String getExceptionMessage() {
        String exceptionMessage = "Failed to invoke operation " + this.op.getId();
        if (this.op.getAliases() != null && this.op.getAliases().length > 0) {
            exceptionMessage = exceptionMessage + " with aliases " + Arrays.toString(this.op.getAliases());
        }
        return exceptionMessage;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.method + ", " + this.priority + ")";
    }

    @Override
    public int compareTo(InvokableMethod o) {
        Class<?>[] opt;
        int cmp = this.method.getName().compareTo(o.method.getName());
        if (cmp != 0) {
            return cmp;
        }
        Class<?>[] pt = this.method.getParameterTypes();
        cmp = pt.length - (opt = o.method.getParameterTypes()).length;
        if (cmp != 0) {
            return cmp;
        }
        for (int i = 0; i < pt.length; ++i) {
            cmp = pt[i].getName().compareTo(opt[i].getName());
            if (cmp == 0) continue;
            return cmp;
        }
        return 0;
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getProduce() {
        return this.produce;
    }

    public Class<?> getConsume() {
        return this.consume;
    }
}

