/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.AutomationAdmin;
import org.nuxeo.ecm.automation.AutomationFilter;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.ChainException;
import org.nuxeo.ecm.automation.CompiledChain;
import org.nuxeo.ecm.automation.OperationChain;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.OperationDocumentation;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationNotFoundException;
import org.nuxeo.ecm.automation.OperationParameters;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.TypeAdapter;
import org.nuxeo.ecm.automation.core.exception.CatchChainException;
import org.nuxeo.ecm.automation.core.exception.ChainExceptionRegistry;
import org.nuxeo.ecm.automation.core.impl.AdapterKeyedRegistry;
import org.nuxeo.ecm.automation.core.impl.AutomationFilterRegistry;
import org.nuxeo.ecm.automation.core.impl.ChainTypeImpl;
import org.nuxeo.ecm.automation.core.impl.OperationChainCompiler;
import org.nuxeo.ecm.automation.core.impl.OperationTypeImpl;
import org.nuxeo.ecm.automation.core.impl.OperationTypeRegistry;
import org.nuxeo.ecm.automation.core.impl.TypeAdapterKey;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetDefinition;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.config.ConfigurationService;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class OperationServiceImpl
implements AutomationService,
AutomationAdmin {
    private static final Log log = LogFactory.getLog(OperationServiceImpl.class);
    public static final String EXPORT_ALIASES_CONFIGURATION_PARAM = "nuxeo.automation.export.aliases";
    protected final OperationTypeRegistry operations;
    protected final ChainExceptionRegistry chainExceptionRegistry;
    protected final AutomationFilterRegistry automationFilterRegistry;
    protected final OperationChainCompiler compiler = new OperationChainCompiler(this);
    protected AdapterKeyedRegistry adapters;
    final Map<String, OperationType> typeofChains = new HashMap<String, OperationType>();

    public OperationServiceImpl() {
        this.operations = new OperationTypeRegistry();
        this.adapters = new AdapterKeyedRegistry();
        this.chainExceptionRegistry = new ChainExceptionRegistry();
        this.automationFilterRegistry = new AutomationFilterRegistry();
    }

    @Override
    public Object run(OperationContext ctx, String operationId) throws OperationException {
        return this.run(ctx, this.getOperationChain(operationId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object run(OperationContext ctx, String operationId, Map<String, ?> args) throws OperationException {
        OperationType op = this.operations.lookup().get(operationId);
        if (op == null) {
            throw new IllegalArgumentException("No such operation " + operationId);
        }
        if (args == null) {
            log.warn((Object)("null operation parameters given for " + operationId), new Throwable("stack trace"));
            args = Collections.emptyMap();
        }
        ctx.push(args);
        try {
            Object object = this.run(ctx, this.getOperationChain(operationId));
            return object;
        }
        finally {
            ctx.pop(args);
        }
    }

    @Override
    public Object run(OperationContext ctx, OperationChain chain) throws OperationException {
        Object input = ctx.getInput();
        Class<Void> inputType = input == null ? Void.TYPE : input.getClass();
        CompiledChain compiled = this.compileChain(inputType, chain);
        boolean completedAbruptly = true;
        try {
            Object result = compiled.invoke(ctx);
            completedAbruptly = false;
            Object object = result;
            return object;
        }
        catch (OperationException cause) {
            completedAbruptly = false;
            if (this.hasChainException(chain.getId())) {
                Object object = this.run(ctx, this.getChainExceptionToRun(ctx, chain.getId(), cause));
                return object;
            }
            throw cause;
        }
        finally {
            if (completedAbruptly) {
                ctx.setRollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object runInNewTx(OperationContext ctx, String chainId, Map<String, ?> chainParameters, Integer timeout, boolean rollbackGlobalOnError) throws OperationException {
        Object result = null;
        if (TransactionHelper.isTransactionMarkedRollback()) {
            return null;
        }
        TransactionHelper.commitOrRollbackTransaction();
        int to = timeout == null ? 0 : timeout;
        TransactionHelper.startTransaction((int)to);
        boolean ok = false;
        try {
            result = this.run(ctx, chainId, chainParameters);
            ok = true;
        }
        catch (OperationException e) {
            if (rollbackGlobalOnError) {
                throw e;
            }
            log.error((Object)("Error while executing operation " + chainId), (Throwable)e);
        }
        finally {
            if (!ok) {
                TransactionHelper.setTransactionRollbackOnly();
            }
            TransactionHelper.commitOrRollbackTransaction();
            TransactionHelper.startTransaction();
        }
        return result;
    }

    protected String getChainExceptionToRun(OperationContext ctx, String operationTypeId, OperationException oe) throws OperationException {
        ctx.put("Exception", (Object)oe.getClass().getSimpleName());
        ctx.put("exceptionName", (Object)oe.getClass().getSimpleName());
        ctx.put("exceptionObject", (Object)oe);
        ChainException chainException = this.getChainException(operationTypeId);
        CatchChainException catchChainException = new CatchChainException();
        for (CatchChainException catchChainExceptionItem : chainException.getCatchChainExceptions()) {
            if (catchChainExceptionItem.hasFilter().booleanValue()) {
                AutomationFilter filter = this.getAutomationFilter(catchChainExceptionItem.getFilterId());
                try {
                    String filterValue = (String)filter.getValue().eval(ctx);
                    if (!Boolean.parseBoolean(filterValue)) continue;
                    catchChainException = this.getCatchChainExceptionByPriority(catchChainException, catchChainExceptionItem);
                    continue;
                }
                catch (RuntimeException e) {
                    throw new OperationException("Cannot evaluate Automation Filter " + filter.getId() + " mvel expression.", e);
                }
            }
            catchChainException = this.getCatchChainExceptionByPriority(catchChainException, catchChainExceptionItem);
        }
        String chainId = catchChainException.getChainId();
        if (chainId.isEmpty()) {
            throw new OperationException("No chain exception has been selected to be run. You should verify Automation filters applied.");
        }
        if (catchChainException.getRollBack().booleanValue()) {
            ctx.setRollback();
        }
        return catchChainException.getChainId();
    }

    protected CatchChainException getCatchChainExceptionByPriority(CatchChainException catchChainException, CatchChainException catchChainExceptionItem) {
        return catchChainException.getPriority() <= catchChainExceptionItem.getPriority() ? catchChainExceptionItem : catchChainException;
    }

    public static OperationParameters[] toParams(String ... ids) {
        OperationParameters[] operationParameters = new OperationParameters[ids.length];
        for (int i = 0; i < ids.length; ++i) {
            operationParameters[i] = new OperationParameters(ids[i]);
        }
        return operationParameters;
    }

    @Override
    public void putOperationChain(OperationChain chain) throws OperationException {
        this.putOperationChain(chain, false);
    }

    @Override
    public void putOperationChain(OperationChain chain, boolean replace) throws OperationException {
        OperationType typeof = OperationType.typeof(chain, replace);
        this.putOperation(typeof, replace);
        this.typeofChains.put(chain.getId(), typeof);
    }

    @Override
    public void removeOperationChain(String id) {
        OperationType typeof = this.operations.lookup().get(id);
        if (typeof == null) {
            throw new IllegalArgumentException("no such chain " + id);
        }
        this.removeOperation(typeof);
    }

    @Override
    public OperationChain getOperationChain(String id) throws OperationNotFoundException {
        OperationType type = this.getOperation(id);
        if (type instanceof ChainTypeImpl) {
            return ((ChainTypeImpl)type).chain;
        }
        OperationChain chain = new OperationChain(id);
        chain.add(id);
        return chain;
    }

    @Override
    public List<OperationChain> getOperationChains() {
        ArrayList<ChainTypeImpl> chainsType = new ArrayList<ChainTypeImpl>();
        ArrayList<OperationChain> chains = new ArrayList<OperationChain>();
        for (OperationType operationType : this.operations.lookup().values()) {
            if (!(operationType instanceof ChainTypeImpl)) continue;
            chainsType.add((ChainTypeImpl)operationType);
        }
        for (ChainTypeImpl chainType : chainsType) {
            chains.add(chainType.getChain());
        }
        return chains;
    }

    @Override
    public synchronized void flushCompiledChains() {
        this.compiler.cache.clear();
    }

    @Override
    public void putOperation(Class<?> type) throws OperationException {
        OperationTypeImpl op = new OperationTypeImpl(this, type);
        this.putOperation(op, false);
    }

    @Override
    public void putOperation(Class<?> type, boolean replace) throws OperationException {
        this.putOperation(type, replace, null);
    }

    @Override
    public void putOperation(Class<?> type, boolean replace, String contributingComponent) throws OperationException {
        OperationTypeImpl op = new OperationTypeImpl(this, type, contributingComponent);
        this.putOperation(op, replace);
    }

    @Override
    public void putOperation(Class<?> type, boolean replace, String contributingComponent, List<WidgetDefinition> widgetDefinitionList) throws OperationException {
        OperationTypeImpl op = new OperationTypeImpl(this, type, contributingComponent, widgetDefinitionList);
        this.putOperation(op, replace);
    }

    @Override
    public void putOperation(OperationType op, boolean replace) throws OperationException {
        this.operations.addContribution(op, replace);
    }

    @Override
    public void removeOperation(Class<?> key) {
        OperationType type = this.operations.getOperationType(key);
        if (type == null) {
            log.warn((Object)("Cannot remove operation, no such operation " + key));
            return;
        }
        this.removeOperation(type);
    }

    @Override
    public void removeOperation(OperationType type) {
        this.operations.removeContribution(type);
    }

    @Override
    public OperationType[] getOperations() {
        HashSet<OperationType> values = new HashSet<OperationType>(this.operations.lookup().values());
        return values.toArray(new OperationType[values.size()]);
    }

    @Override
    public OperationType getOperation(String id) throws OperationNotFoundException {
        OperationType op = this.operations.lookup().get(id);
        if (op == null) {
            throw new OperationNotFoundException("No operation was bound on ID: " + id);
        }
        return op;
    }

    @Override
    public boolean hasOperation(String id) {
        OperationType op = this.operations.lookup().get(id);
        return op != null;
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationParameters ... ops) throws OperationException {
        return this.compileChain(inputType, new OperationChain("", Arrays.asList(ops)));
    }

    @Override
    public CompiledChain compileChain(Class<?> inputType, OperationChain chain) throws OperationException {
        return this.compiler.compile(ChainTypeImpl.typeof(chain, false), inputType);
    }

    @Override
    public void putTypeAdapter(Class<?> accept, Class<?> produce, TypeAdapter adapter) {
        this.adapters.put(new TypeAdapterKey(accept, produce), adapter);
    }

    @Override
    public void removeTypeAdapter(Class<?> accept, Class<?> produce) {
        this.adapters.remove(new TypeAdapterKey(accept, produce));
    }

    @Override
    public TypeAdapter getTypeAdapter(Class<?> accept, Class<?> produce) {
        return (TypeAdapter)this.adapters.get(new TypeAdapterKey(accept, produce));
    }

    @Override
    public boolean isTypeAdaptable(Class<?> typeToAdapt, Class<?> targetType) {
        return this.getTypeAdapter(typeToAdapt, targetType) != null;
    }

    @Override
    public <T> T getAdaptedValue(OperationContext ctx, Object toAdapt, Class<?> targetType) throws OperationException {
        Class toAdaptClass;
        if (targetType.isAssignableFrom(Void.class)) {
            return null;
        }
        if (OperationContext.class.isAssignableFrom(targetType)) {
            return (T)ctx;
        }
        Class clazz = toAdaptClass = toAdapt == null ? Void.class : toAdapt.getClass();
        if (targetType.isPrimitive() && (targetType = OperationServiceImpl.getTypeForPrimitive(targetType)).isAssignableFrom(toAdaptClass)) {
            return (T)toAdapt;
        }
        if (targetType.isArray() && toAdapt instanceof List) {
            Iterable iterable = (Iterable)toAdapt;
            return (T)Iterables.toArray((Iterable)iterable, targetType.getComponentType());
        }
        TypeAdapter adapter = this.getTypeAdapter(toAdaptClass, targetType);
        if (adapter == null) {
            if (toAdapt == null) {
                return null;
            }
            if (toAdapt instanceof JsonNode) {
                ObjectMapper mapper = new ObjectMapper();
                return (T)mapper.convertValue(toAdapt, targetType);
            }
            if (targetType.isAssignableFrom(OperationContext.class)) {
                return (T)ctx;
            }
            throw new OperationException("No type adapter found for input: " + toAdaptClass + " and output " + targetType);
        }
        return (T)adapter.getAdaptedValue(ctx, toAdapt);
    }

    @Override
    public List<OperationDocumentation> getDocumentation() throws OperationException {
        ArrayList<OperationDocumentation> result = new ArrayList<OperationDocumentation>();
        HashSet<OperationType> ops = new HashSet<OperationType>(this.operations.lookup().values());
        ConfigurationService configurationService = (ConfigurationService)Framework.getService(ConfigurationService.class);
        boolean exportAliases = configurationService.isBooleanPropertyTrue(EXPORT_ALIASES_CONFIGURATION_PARAM);
        for (OperationType ot : ops.toArray(new OperationType[ops.size()])) {
            try {
                OperationDocumentation documentation = ot.getDocumentation();
                result.add(documentation);
                String[] aliases = ot.getAliases();
                if (!exportAliases || aliases == null || aliases.length <= 0) continue;
                for (String alias : aliases) {
                    result.add(OperationDocumentation.copyForAlias(documentation, alias));
                }
            }
            catch (OperationNotFoundException operationNotFoundException) {
                // empty catch block
            }
        }
        Collections.sort(result);
        return result;
    }

    public static Class<?> getTypeForPrimitive(Class<?> primitiveType) {
        if (primitiveType == Boolean.TYPE) {
            return Boolean.class;
        }
        if (primitiveType == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveType == Long.TYPE) {
            return Long.class;
        }
        if (primitiveType == Float.TYPE) {
            return Float.class;
        }
        if (primitiveType == Double.TYPE) {
            return Double.class;
        }
        if (primitiveType == Character.TYPE) {
            return Character.class;
        }
        if (primitiveType == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveType == Short.TYPE) {
            return Short.class;
        }
        return primitiveType;
    }

    @Override
    public void putChainException(ChainException exceptionChain) {
        this.chainExceptionRegistry.addContribution(exceptionChain);
    }

    @Override
    public void removeExceptionChain(ChainException exceptionChain) {
        this.chainExceptionRegistry.removeContribution(exceptionChain);
    }

    @Override
    public ChainException[] getChainExceptions() {
        Collection<ChainException> chainExceptions = this.chainExceptionRegistry.lookup().values();
        return chainExceptions.toArray(new ChainException[chainExceptions.size()]);
    }

    @Override
    public ChainException getChainException(String onChainId) {
        return this.chainExceptionRegistry.getChainException(onChainId);
    }

    @Override
    public boolean hasChainException(String onChainId) {
        return this.chainExceptionRegistry.getChainException(onChainId) != null;
    }

    @Override
    public void putAutomationFilter(AutomationFilter automationFilter) {
        this.automationFilterRegistry.addContribution(automationFilter);
    }

    @Override
    public void removeAutomationFilter(AutomationFilter automationFilter) {
        this.automationFilterRegistry.removeContribution(automationFilter);
    }

    @Override
    public AutomationFilter getAutomationFilter(String id) {
        return this.automationFilterRegistry.getAutomationFilter(id);
    }

    @Override
    public AutomationFilter[] getAutomationFilters() {
        Collection<AutomationFilter> automationFilters = this.automationFilterRegistry.lookup().values();
        return automationFilters.toArray(new AutomationFilter[automationFilters.size()]);
    }
}

