/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.blob;

import java.net.URL;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.URLBlob;

@Operation(id="Blob.CreateFromURL", category="Fetch", label="File From URL", description="Creates a file from a given URL. The file parameter specifies how to retrieve the file content. It should be an URL to the file you want to use as the source. You can also use an expression to get an URL from the context. Returns the created file.", aliases={"Blob.Create"})
public class CreateBlob {
    public static final String ID = "Blob.CreateFromURL";
    public static boolean skipProtocolCheck;
    @Param(name="file")
    protected URL file;
    @Param(name="mime-type", required=false)
    protected String mimeType;
    @Param(name="filename", required=false)
    protected String fileName;
    @Param(name="encoding", required=false)
    protected String encoding;

    @OperationMethod
    public Blob run() {
        String protocol = this.file.getProtocol();
        if (!("http".equals(protocol) || "https".equals(protocol) || "ftp".equals(protocol) || skipProtocolCheck)) {
            return null;
        }
        if (this.fileName == null) {
            this.fileName = this.file.getPath();
            int i = this.fileName.lastIndexOf(47);
            if (i > -1) {
                this.fileName = this.fileName.substring(i + 1);
            }
        }
        if (this.mimeType == null) {
            // empty if block
        }
        URLBlob blob = new URLBlob(this.file, this.mimeType, this.encoding);
        blob.setFilename(this.fileName);
        return blob;
    }
}

