/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.io.Serializable;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.VersioningOption;

@Operation(id="Document.CreateVersion", category="Document", label="Snapshot Version", description="Create a new version for the input document. Any modification made on the document by the chain will be automatically saved. Increment version if this was specified through the 'snapshot' parameter. Returns the live document (not the version).")
public class CreateVersion {
    public static final String ID = "Document.CreateVersion";
    @Context
    protected CoreSession session;
    @Param(name="increment", required=false, widget="Option", values={"None", "Minor", "Major"})
    protected String snapshot = "None";
    @Param(name="saveDocument", required=false, widget="Check", description="Save the document in the session after versioning")
    protected boolean saveDocument = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        if (!doc.hasFacet("Versionable")) {
            throw new NuxeoException(String.format("The document (id:'%s') with title '%s' doesn't have 'versionable' facet", doc.getId(), doc.getTitle()));
        }
        Object vo = "Minor".equalsIgnoreCase(this.snapshot) ? VersioningOption.MINOR : ("Major".equalsIgnoreCase(this.snapshot) ? VersioningOption.MAJOR : null);
        if (vo != null) {
            doc.putContextData("VersioningOption", (Serializable)vo);
        }
        if (this.saveDocument) {
            return DocumentHelper.saveDocument(this.session, doc);
        }
        return doc;
    }
}

