/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;

@Operation(id="Document.Move", category="Document", label="Move", description="Move the input document into the target folder.")
public class MoveDocument {
    public static final String ID = "Document.Move";
    @Context
    protected CoreSession session;
    @Param(name="target")
    protected DocumentRef target;
    @Param(name="name", required=false)
    protected String name;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        String n = this.name;
        if (this.name == null || this.name.length() == 0) {
            n = doc.getName();
        }
        return this.session.move(doc.getRef(), this.target, n);
    }

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentRef ref) {
        String n = this.name;
        if (this.name == null || this.name.length() == 0) {
            n = this.session.getDocument(ref).getName();
        }
        return this.session.move(ref, this.target, n);
    }
}

