/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import java.util.List;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.core.trash.TrashService;

@Operation(id="Document.Trash", category="Document", label="Trash", description="Moves documents to the trash.")
public class TrashDocument {
    public static final String ID = "Document.Trash";
    @Context
    protected CoreSession session;
    @Context
    protected TrashService trashService;

    @OperationMethod
    public DocumentModel run(DocumentModel doc) {
        this.trashService.trashDocument(doc);
        return this.session.getDocument(doc.getRef());
    }

    @OperationMethod
    public DocumentModelList run(DocumentModelList docs) {
        this.trashService.trashDocuments((List)docs);
        DocumentModelListImpl result = new DocumentModelListImpl();
        for (DocumentModel doc : docs) {
            if (!this.session.exists(doc.getRef())) continue;
            result.add((Object)this.session.getDocument(doc.getRef()));
        }
        return result;
    }
}

