/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.document;

import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.trash.TrashService;

@Operation(id="Document.Untrash", category="Document", label="Untrash", description="Undeletes documents (and ancestors if needed to make them visible)..")
public class UntrashDocument {
    public static final String ID = "Document.Untrash";
    @Context
    protected CoreSession session;
    @Context
    protected TrashService trashService;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) {
        if (this.trashService.canPurgeOrUntrash(doc, this.session.getPrincipal())) {
            this.trashService.untrashDocument(doc);
            return this.session.getDocument(doc.getRef());
        }
        throw new NuxeoException("Cannot untrash these documents");
    }
}

