/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.traces;

import java.io.IOException;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.trace.Trace;
import org.nuxeo.ecm.automation.core.trace.TracerFactory;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

@Operation(id="Traces.Get", category="Execution Context", label="Traces.getTrace", description="Retrieve trace associated to a Chain or an Operation", addToStudio=false)
public class AutomationTraceGetOperation {
    public static final String ID = "Traces.Get";
    @Param(name="traceKey", required=false)
    protected String traceKey = null;
    @Param(name="index", required=false)
    protected int index = -1;
    @Context
    protected OperationContext ctx;

    protected boolean canManageTraces() {
        NuxeoPrincipal principal = (NuxeoPrincipal)this.ctx.getPrincipal();
        return principal != null && principal.isAdministrator();
    }

    @OperationMethod
    public String run() throws IOException {
        if (!this.canManageTraces()) {
            return null;
        }
        TracerFactory tracerFactory = (TracerFactory)Framework.getService(TracerFactory.class);
        if (this.traceKey == null) {
            Trace trace = tracerFactory.getLastErrorTrace();
            if (trace != null) {
                return tracerFactory.print(trace);
            }
            return "no previous error trace found";
        }
        Trace trace = tracerFactory.getTrace(this.traceKey);
        if (trace != null) {
            return tracerFactory.print(trace);
        }
        return "no trace found";
    }
}

