/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import org.nuxeo.common.utils.URIUtils;
import org.nuxeo.ecm.automation.core.util.DateTimeFormat;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.primitives.BlobProperty;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BinaryType;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;

public class JSONPropertyWriter {
    protected DateTimeFormat dateTimeFormat = DateTimeFormat.W3C;
    protected String filesBaseUrl;
    protected String prefix;
    protected boolean writeNull = true;
    protected boolean writeEmpty = true;

    protected JSONPropertyWriter() {
    }

    protected JSONPropertyWriter(JSONPropertyWriter writer) {
        this.dateTimeFormat = writer.dateTimeFormat;
        this.filesBaseUrl = writer.filesBaseUrl;
        this.prefix = writer.prefix;
        this.writeNull = writer.writeNull;
    }

    public static JSONPropertyWriter create() {
        return new JSONPropertyWriter();
    }

    public JSONPropertyWriter dateTimeFormat(DateTimeFormat dateTimeFormat) {
        this.dateTimeFormat = dateTimeFormat;
        return this;
    }

    public JSONPropertyWriter filesBaseUrl(String filesBaseUrl) {
        this.filesBaseUrl = filesBaseUrl;
        if (this.filesBaseUrl != null && !this.filesBaseUrl.endsWith("/")) {
            this.filesBaseUrl = this.filesBaseUrl + "/";
        }
        return this;
    }

    public JSONPropertyWriter prefix(String prefix) {
        this.prefix = prefix;
        return this;
    }

    public JSONPropertyWriter writeNull(boolean writeNull) {
        this.writeNull = writeNull;
        return this;
    }

    public JSONPropertyWriter writeEmpty(boolean writeEmpty) {
        this.writeEmpty = writeEmpty;
        return this;
    }

    public void writeProperty(JsonGenerator jg, Property prop) throws PropertyException, JsonGenerationException, IOException {
        PropertyConsumer fieldNameWriter = this.prefix == null ? (j, p) -> j.writeFieldName(p.getName()) : (j, p) -> j.writeFieldName(this.prefix + ':' + p.getField().getName().getLocalName());
        this.writeProperty(jg, prop, fieldNameWriter);
    }

    protected void writeProperty(JsonGenerator jg, Property prop, PropertyConsumer fieldNameWriter) throws PropertyException, JsonGenerationException, IOException {
        if (prop.isScalar()) {
            this.writeScalarProperty(jg, prop, fieldNameWriter);
        } else if (prop.isList()) {
            this.writeListProperty(jg, prop, fieldNameWriter);
        } else if (prop.isPhantom()) {
            if (this.writeNull) {
                fieldNameWriter.accept(jg, prop);
                jg.writeNull();
            }
        } else if (prop instanceof BlobProperty) {
            this.writeBlobProperty(jg, prop, fieldNameWriter);
        } else {
            this.writeMapProperty(jg, (ComplexProperty)prop, fieldNameWriter);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeScalarProperty(JsonGenerator jg, Property prop, PropertyConsumer fieldNameWriter) throws PropertyException, JsonGenerationException, IOException {
        Type type = prop.getType();
        Serializable v = prop.getValue();
        if (v == null) {
            if (!this.writeNull) return;
            fieldNameWriter.accept(jg, prop);
            jg.writeNull();
            return;
        } else {
            fieldNameWriter.accept(jg, prop);
            if (type instanceof BooleanType) {
                jg.writeBoolean(((Boolean)v).booleanValue());
                return;
            } else if (type instanceof LongType) {
                jg.writeNumber(((Long)v).longValue());
                return;
            } else if (type instanceof DoubleType) {
                jg.writeNumber(((Double)v).doubleValue());
                return;
            } else if (type instanceof IntegerType) {
                jg.writeNumber(((Integer)v).intValue());
                return;
            } else if (type instanceof BinaryType) {
                jg.writeBinary((byte[])v);
                return;
            } else if (type instanceof DateType && this.dateTimeFormat == DateTimeFormat.TIME_IN_MILLIS) {
                if (v instanceof Date) {
                    jg.writeNumber(((Date)v).getTime());
                    return;
                } else {
                    if (!(v instanceof Calendar)) throw new PropertyException("Unknown class for DateType: " + v.getClass().getName() + ", " + v);
                    jg.writeNumber(((Calendar)v).getTimeInMillis());
                }
                return;
            } else {
                jg.writeString(type.encode((Object)v));
            }
        }
    }

    protected void writeListProperty(JsonGenerator jg, Property prop, PropertyConsumer fieldNameWriter) throws PropertyException, JsonGenerationException, IOException {
        if (!this.writeEmpty && (prop == null || prop instanceof ArrayProperty && prop.getValue() == null || prop instanceof ListProperty && prop.getChildren().isEmpty())) {
            return;
        }
        fieldNameWriter.accept(jg, prop);
        jg.writeStartArray();
        if (prop instanceof ArrayProperty) {
            Object[] ar = (Object[])prop.getValue();
            if (ar == null) {
                jg.writeEndArray();
                return;
            }
            Type type = ((ListType)prop.getType()).getFieldType();
            for (Object o : ar) {
                jg.writeString(type.encode(o));
            }
        } else {
            for (Property p : prop.getChildren()) {
                this.writeProperty(jg, p, PropertyConsumer.nothing());
            }
        }
        jg.writeEndArray();
    }

    protected void writeMapProperty(JsonGenerator jg, ComplexProperty prop, PropertyConsumer fieldNameWriter) throws PropertyException, JsonGenerationException, IOException {
        if (!this.writeEmpty && (prop == null || prop.getChildren().isEmpty())) {
            return;
        }
        fieldNameWriter.accept(jg, (Property)prop);
        jg.writeStartObject();
        PropertyConsumer childFieldWriter = (j, p) -> j.writeFieldName(p.getName());
        for (Property p2 : prop.getChildren()) {
            this.writeProperty(jg, p2, childFieldWriter);
        }
        jg.writeEndObject();
    }

    protected void writeBlobProperty(JsonGenerator jg, Property prop, PropertyConsumer fieldNameWriter) throws PropertyException, JsonGenerationException, IOException {
        Blob blob = (Blob)prop.getValue();
        if (blob == null) {
            if (this.writeNull) {
                fieldNameWriter.accept(jg, prop);
                jg.writeNull();
            }
        } else {
            fieldNameWriter.accept(jg, prop);
            jg.writeStartObject();
            String v = blob.getFilename();
            if (v == null) {
                if (this.writeNull) {
                    jg.writeNullField("name");
                }
            } else {
                jg.writeStringField("name", v);
            }
            if ((v = blob.getMimeType()) == null) {
                if (this.writeNull) {
                    jg.writeNullField("mime-type");
                }
            } else {
                jg.writeStringField("mime-type", v);
            }
            if ((v = blob.getEncoding()) == null) {
                if (this.writeNull) {
                    jg.writeNullField("encoding");
                }
            } else {
                jg.writeStringField("encoding", v);
            }
            if ((v = blob.getDigest()) == null) {
                if (this.writeNull) {
                    jg.writeNullField("digest");
                }
            } else {
                jg.writeStringField("digest", v);
            }
            jg.writeNumberField("length", blob.getLength());
            if (this.filesBaseUrl != null) {
                jg.writeStringField("data", JSONPropertyWriter.getBlobUrl(prop, this.filesBaseUrl));
            }
            jg.writeEndObject();
        }
    }

    private static String getBlobUrl(Property prop, String filesBaseUrl) throws UnsupportedEncodingException, PropertyException {
        StringBuilder blobUrlBuilder = new StringBuilder(filesBaseUrl);
        String xpath = prop.getXPath();
        if (!xpath.contains(":")) {
            xpath = prop.getSchema().getName() + ":" + xpath;
        }
        blobUrlBuilder.append(xpath);
        blobUrlBuilder.append("/");
        String filename = ((Blob)prop.getValue()).getFilename();
        if (filename != null) {
            blobUrlBuilder.append(URIUtils.quoteURIPathComponent((String)filename, (boolean)true));
        }
        return blobUrlBuilder.toString();
    }

    public static void writePropertyValue(JsonGenerator jg, Property prop, DateTimeFormat dateTimeFormat, String filesBaseUrl) throws PropertyException, JsonGenerationException, IOException {
        JSONPropertyWriter writer = JSONPropertyWriter.create().dateTimeFormat(dateTimeFormat).filesBaseUrl(filesBaseUrl);
        writer.writeProperty(jg, prop, PropertyConsumer.nothing());
    }

    @FunctionalInterface
    public static interface PropertyConsumer {
        public void accept(JsonGenerator var1, Property var2) throws JsonGenerationException, IOException;

        public static PropertyConsumer nothing() {
            return (jg, prop) -> {};
        }
    }
}

