/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.work;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.AsyncBlob;
import org.nuxeo.ecm.core.io.download.DownloadService;
import org.nuxeo.ecm.core.transientstore.api.TransientStore;
import org.nuxeo.ecm.core.transientstore.api.TransientStoreService;
import org.nuxeo.ecm.core.transientstore.work.TransientStoreWork;
import org.nuxeo.ecm.core.utils.BlobUtils;
import org.nuxeo.runtime.api.Framework;

public class BlobListZipWork
extends TransientStoreWork {
    private static final Log log = LogFactory.getLog(BlobListZipWork.class);
    public static final String CATEGORY = "blobListZip";
    public static final String CACHE_NAME = "blobListZip";
    private static final long serialVersionUID = 1L;
    protected String filename;
    protected final String key;
    protected final String storeName;

    public BlobListZipWork(String transientStoreKey, String originatingUsername, String filename, List<String> docIds) {
        this(transientStoreKey, originatingUsername, filename, docIds, filename);
    }

    public BlobListZipWork(String transientStoreKey, String originatingUsername, String filename, List<String> docIds, String storeName) {
        this.key = transientStoreKey;
        this.docIds = docIds;
        this.originatingUsername = originatingUsername;
        this.id = "BlobListZipWork-" + this.key + "-" + this.originatingUsername;
        this.storeName = storeName;
        if (StringUtils.isNotBlank((CharSequence)filename)) {
            this.filename = filename.toLowerCase().endsWith(".zip") ? filename : filename + ".zip";
        }
    }

    public void cleanUp(boolean ok, Exception e) {
        super.cleanUp(ok, e);
        if (ok) {
            return;
        }
        List<AsyncBlob> blobs = Collections.singletonList(new AsyncBlob(this.key));
        TransientStore ts = this.getTransientStore();
        ts.putParameter(this.key, "error", (Serializable)((Object)e.getMessage()));
        this.updateAndCompleteStoreEntry(blobs);
    }

    public String getCategory() {
        return "blobListZip";
    }

    public String getTitle() {
        return this.id;
    }

    public TransientStore getTransientStore() {
        TransientStoreService tss = (TransientStoreService)Framework.getService(TransientStoreService.class);
        return tss.getStore(this.storeName != null ? this.storeName : CACHE_NAME);
    }

    protected void updateAndCompleteStoreEntry(List<Blob> blobs) {
        TransientStore ts = this.getTransientStore();
        if (!ts.exists(this.key)) {
            throw new NuxeoException("Zip TransientStore entry can not be null");
        }
        ts.putBlobs(this.key, blobs);
        ts.putParameter(this.key, "progress", (Serializable)Integer.valueOf(100));
        ts.setCompleted(this.key, true);
    }

    public void work() {
        Blob blob;
        this.openUserSession();
        ArrayList<Blob> blobList = new ArrayList<Blob>();
        DownloadService downloadService = (DownloadService)Framework.getService(DownloadService.class);
        for (String docId : this.docIds) {
            IdRef docRef = new IdRef(docId);
            if (!this.session.exists((DocumentRef)docRef)) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Cannot retrieve document '%s', probably deleted in the meanwhile", docId));
                continue;
            }
            DocumentModel doc = this.session.getDocument((DocumentRef)docRef);
            Blob blob2 = downloadService.resolveBlob(doc);
            if (blob2 == null) {
                log.trace((Object)"Not able to resolve blob");
                continue;
            }
            if (!downloadService.checkPermission(doc, null, blob2, "download", Collections.emptyMap())) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("Not allowed to bulk download blob for document %s", doc.getPathAsString()));
                continue;
            }
            blobList.add(blob2);
        }
        if (blobList.isEmpty()) {
            log.debug((Object)"No blob to be zipped");
            this.updateAndCompleteStoreEntry(Collections.emptyList());
            return;
        }
        String finalFilename = StringUtils.isNotBlank((CharSequence)this.filename) ? this.filename : this.id;
        try {
            blob = BlobUtils.zip(blobList, (String)finalFilename);
        }
        catch (IOException e) {
            TransientStore ts = this.getTransientStore();
            ts.putParameter(this.key, "error", (Serializable)((Object)e.getMessage()));
            throw new NuxeoException("Exception while zipping blob list", (Throwable)e);
        }
        this.updateAndCompleteStoreEntry(Collections.singletonList(blob));
    }
}

