/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRow;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class LayoutJsonWriter
extends AbstractJsonWriter<Layout> {
    public void write(Layout entity, JsonGenerator jg) throws IOException {
        LayoutRow[] lRows;
        Map properties;
        String typeCat;
        jg.writeStartObject();
        jg.writeStringField("name", entity.getName());
        String type = entity.getType();
        if (type != null) {
            jg.writeStringField("type", type);
        }
        if ((typeCat = entity.getTypeCategory()) != null) {
            jg.writeStringField("typeCategory", typeCat);
        }
        jg.writeStringField("mode", entity.getMode());
        String template = entity.getTemplate();
        if (template != null) {
            jg.writeStringField("template", template);
        }
        if (MapUtils.isNotEmpty((Map)(properties = entity.getProperties()))) {
            this.writeSerializableMapField("properties", properties, jg);
        }
        if ((lRows = entity.getRows()) != null) {
            jg.writeArrayFieldStart("rows");
            for (LayoutRow lRow : lRows) {
                this.writeLayoutRow(lRow, jg);
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
    }

    protected void writeLayoutRow(LayoutRow layoutRow, JsonGenerator jg) throws IOException {
        Object[] widgets;
        Map properties;
        jg.writeStartObject();
        String name = layoutRow.getName();
        if (name != null) {
            jg.writeStringField("name", name);
        }
        if (layoutRow.isAlwaysSelected()) {
            jg.writeBooleanField("alwaysSelected", true);
        }
        if (!layoutRow.isSelectedByDefault()) {
            jg.writeBooleanField("selectedByDefault", false);
        }
        if (MapUtils.isNotEmpty((Map)(properties = layoutRow.getProperties()))) {
            this.writeSerializableMapField("properties", properties, jg);
        }
        if (ArrayUtils.isNotEmpty((Object[])(widgets = layoutRow.getWidgets()))) {
            jg.writeArrayFieldStart("widgets");
            for (Object widget : widgets) {
                this.writeWidget((Widget)widget, jg);
            }
            jg.writeEndArray();
        }
        jg.writeEndObject();
    }

    protected void writeWidget(Widget widget, JsonGenerator jg) throws IOException {
        Object[] selectOptions;
        Map controls;
        Map properties;
        Object[] subWidgets;
        jg.writeStartObject();
        jg.writeStringField("name", widget.getName());
        jg.writeStringField("type", widget.getType());
        jg.writeStringField("typeCategory", widget.getTypeCategory());
        jg.writeStringField("mode", widget.getMode());
        jg.writeStringField("label", widget.getLabel());
        String helpLabel = widget.getHelpLabel();
        if (StringUtils.isNotBlank((CharSequence)helpLabel)) {
            jg.writeStringField("helpLabel", helpLabel);
        }
        jg.writeBooleanField("translated", widget.isTranslated());
        jg.writeBooleanField("handlingLabels", widget.isHandlingLabels());
        Object[] fieldDefs = widget.getFieldDefinitions();
        if (ArrayUtils.isNotEmpty((Object[])fieldDefs)) {
            jg.writeArrayFieldStart("fields");
            for (Object fieldDef : fieldDefs) {
                this.writeEntity(fieldDef, jg);
            }
            jg.writeEndArray();
        }
        if (ArrayUtils.isNotEmpty((Object[])(subWidgets = widget.getSubWidgets()))) {
            jg.writeArrayFieldStart("subWidgets");
            for (Object wDef : subWidgets) {
                this.writeWidget((Widget)wDef, jg);
            }
            jg.writeEndArray();
        }
        if (MapUtils.isNotEmpty((Map)(properties = widget.getProperties()))) {
            this.writeSerializableMapField("properties", properties, jg);
        }
        if (MapUtils.isNotEmpty((Map)(controls = widget.getControls()))) {
            this.writeSerializableMapField("controls", controls, jg);
        }
        if (ArrayUtils.isNotEmpty((Object[])(selectOptions = widget.getSelectOptions()))) {
            this.writeSerializableListField("selectOptions", Arrays.asList(selectOptions), jg);
        }
        jg.writeEndObject();
    }
}

