/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.core.io.marshallers.json.AbstractJsonWriter;
import org.nuxeo.ecm.core.io.registry.reflect.Instantiations;
import org.nuxeo.ecm.core.io.registry.reflect.Setup;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutTypeConfiguration;

@Setup(mode=Instantiations.SINGLETON, priority=2000)
public class LayoutTypeConfigurationJsonWriter
extends AbstractJsonWriter<LayoutTypeConfiguration> {
    public void write(LayoutTypeConfiguration entity, JsonGenerator jg) throws IOException {
        Map defaultPropValues;
        Map propertyLayouts;
        List categories;
        List supportedControls;
        List supportedModes;
        String demoId;
        jg.writeStartObject();
        jg.writeStringField("title", entity.getTitle());
        String description = entity.getDescription();
        if (StringUtils.isNotBlank((CharSequence)description)) {
            jg.writeStringField("description", description);
        }
        if ((demoId = entity.getDemoId()) != null) {
            jg.writeObjectFieldStart("demo");
            jg.writeStringField("id", demoId);
            jg.writeBooleanField("previewEnabled", entity.isDemoPreviewEnabled());
            jg.writeEndObject();
        }
        jg.writeStringField("sinceVersion", entity.getSinceVersion());
        String deprVersion = entity.getDeprecatedVersion();
        if (StringUtils.isNotBlank((CharSequence)deprVersion)) {
            jg.writeStringField("deprecatedVersion", deprVersion);
        }
        if (CollectionUtils.isNotEmpty((Collection)(supportedModes = entity.getSupportedModes()))) {
            this.writeSerializableListField("supportedModes", supportedModes, jg);
        }
        if (entity.isHandlingLabels()) {
            jg.writeBooleanField("handlingLabels", entity.isHandlingLabels());
        }
        if (CollectionUtils.isNotEmpty((Collection)(supportedControls = entity.getSupportedControls()))) {
            this.writeSerializableListField("supportedControls", supportedControls, jg);
        }
        if (entity.isContainingForm()) {
            jg.writeBooleanField("containingForm", true);
        }
        if (CollectionUtils.isNotEmpty((Collection)(categories = entity.getCategories()))) {
            this.writeSerializableListField("categories", categories, jg);
        }
        if (MapUtils.isNotEmpty((Map)(propertyLayouts = entity.getPropertyLayouts())) && propertyLayouts.values().stream().anyMatch(CollectionUtils::isNotEmpty)) {
            jg.writeObjectFieldStart("properties");
            jg.writeObjectFieldStart("layouts");
            for (Map.Entry entry : new TreeMap(propertyLayouts).entrySet()) {
                this.writeSerializableListField((String)entry.getKey(), (Collection)entry.getValue(), jg);
            }
            jg.writeEndObject();
            jg.writeEndObject();
        }
        if (MapUtils.isNotEmpty((Map)(defaultPropValues = entity.getDefaultPropertyValues()))) {
            jg.writeObjectFieldStart("defaultPropertyValues");
            for (Map.Entry entry : new TreeMap(defaultPropValues).entrySet()) {
                this.writeSerializableMapField((String)entry.getKey(), (Map)entry.getValue(), jg);
            }
            jg.writeEndObject();
        }
        jg.writeEndObject();
    }
}

