/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.export;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.commons.lang3.StringUtils;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeConfiguration;
import org.nuxeo.ecm.platform.forms.layout.api.WidgetTypeDefinition;
import org.nuxeo.ecm.platform.forms.layout.api.impl.WidgetTypeDefinitionComparator;
import org.nuxeo.ecm.platform.forms.layout.api.service.LayoutStore;
import org.nuxeo.ecm.platform.forms.layout.export.WidgetTypeDefinitions;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.view.TemplateView;
import org.nuxeo.runtime.api.Framework;

public class WidgetTypeResource {
    protected final String category;
    protected LayoutStore service;
    protected final List<WidgetTypeDefinition> widgetTypes;
    protected final Map<String, List<WidgetTypeDefinition>> widgetTypesByCat;

    public WidgetTypeResource(String category) {
        this.category = category;
        this.service = (LayoutStore)Framework.getService(LayoutStore.class);
        this.widgetTypes = this.service.getWidgetTypeDefinitions(category);
        Collections.sort(this.widgetTypes, new WidgetTypeDefinitionComparator(true));
        this.widgetTypesByCat = this.getWidgetTypesByCategory();
    }

    protected Map<String, List<WidgetTypeDefinition>> getWidgetTypesByCategory() {
        HashMap cats = new HashMap();
        ArrayList<WidgetTypeDefinition> unknownCatWidgets = new ArrayList<WidgetTypeDefinition>();
        for (WidgetTypeDefinition wTypeDef : this.widgetTypes) {
            List categories = null;
            WidgetTypeConfiguration conf = wTypeDef.getConfiguration();
            if (conf != null) {
                categories = conf.getCategories();
            }
            boolean added = false;
            if (categories != null) {
                for (String cat : categories) {
                    ArrayList<WidgetTypeDefinition> list = (ArrayList<WidgetTypeDefinition>)cats.get(cat);
                    if (list == null) {
                        list = new ArrayList<WidgetTypeDefinition>();
                    }
                    list.add(wTypeDef);
                    cats.put(cat, list);
                    added = true;
                }
            }
            if (added) continue;
            unknownCatWidgets.add(wTypeDef);
        }
        if (!unknownCatWidgets.isEmpty()) {
            cats.put("unknown", unknownCatWidgets);
        }
        ArrayList sortedKeys = new ArrayList(cats.keySet());
        Collections.sort(sortedKeys);
        LinkedHashMap<String, List<WidgetTypeDefinition>> res = new LinkedHashMap<String, List<WidgetTypeDefinition>>();
        for (String key : sortedKeys) {
            res.put(key, (List<WidgetTypeDefinition>)cats.get(key));
        }
        return res;
    }

    @GET
    @Path(value="widgetTypes")
    public Object getWidgetTypeDefinitions(@Context HttpServletRequest request, @QueryParam(value="categories") String categories, @QueryParam(value="version") String version, @QueryParam(value="all") Boolean all) {
        ArrayList<String> catsList = new ArrayList<String>();
        if (categories != null) {
            for (String cat : categories.split(" ")) {
                catsList.add(cat);
            }
        }
        WidgetTypeDefinitions res = new WidgetTypeDefinitions();
        for (WidgetTypeDefinition def : this.widgetTypes) {
            String confVersion;
            WidgetTypeConfiguration conf = def.getConfiguration();
            if (!Boolean.TRUE.equals(all) && conf == null || version != null && conf != null && (confVersion = conf.getSinceVersion()) != null && this.isStriclyBeforeVersion(version, confVersion)) continue;
            if (catsList != null && !catsList.isEmpty()) {
                List confCats;
                boolean hasCats = false;
                if (conf != null && (confCats = conf.getCategories()) != null) {
                    hasCats = true;
                    for (String confCat : confCats) {
                        if (!catsList.contains(confCat)) continue;
                        res.add(def);
                        break;
                    }
                }
                if (hasCats || catsList.size() != 1 || !catsList.contains("unknown")) continue;
                res.add(def);
                continue;
            }
            if (conf == null && !Boolean.TRUE.equals(all)) continue;
            res.add(def);
        }
        return res;
    }

    protected boolean isStriclyBeforeVersion(String ref, String version) {
        if (version == null || version.trim().length() == 0) {
            return true;
        }
        String[] components1 = ref.split("\\.");
        String[] components2 = version.split("\\.");
        int length = Math.min(components1.length, components2.length);
        for (int i = 0; i < length; ++i) {
            int result = Integer.compare(Integer.valueOf(components1[i]), Integer.valueOf(components2[i]));
            if (result == 0) continue;
            return result < 0;
        }
        return components1.length < components2.length;
    }

    @GET
    @Path(value="widgetTypes/{category}")
    public Object getWidgetTypeDefinitionsForCategory(@Context HttpServletRequest request, @PathParam(value="category") String category, @QueryParam(value="version") String version, @QueryParam(value="all") Boolean all) {
        return this.getWidgetTypeDefinitions(request, category, version, all);
    }

    @GET
    @Path(value="widgetType/{name}")
    public Object getWidgetTypeDefinition(@Context HttpServletRequest request, @PathParam(value="name") String name) {
        WidgetTypeDefinition def = this.service.getWidgetTypeDefinition(this.category, name);
        if (def != null) {
            return def;
        }
        return Response.status((int)401).build();
    }

    public TemplateView getTemplate(@Context UriInfo uriInfo) {
        return this.getTemplate("widget-types.ftl", uriInfo);
    }

    @GET
    @Path(value="wiki")
    public Object getWikiDocumentation(@Context UriInfo uriInfo) {
        return this.getTemplate("widget-types-wiki.ftl", uriInfo);
    }

    protected List<String> getNuxeoVersions() {
        if ("jsf".equals(this.category) || "jsfAction".equals(this.category)) {
            return Arrays.asList("5.8", "6.0", "7.10");
        }
        return Collections.emptyList();
    }

    protected List<String> getStudioCategories() {
        return Arrays.asList("aggregates", "decoration", "dev", "document", "listing", "search", "standalone", "summary", "tab_designer");
    }

    protected TemplateView getTemplate(String name, UriInfo uriInfo) {
        String baseURL = uriInfo.getAbsolutePath().toString();
        if (!baseURL.endsWith("/")) {
            baseURL = baseURL + "/";
        }
        TemplateView tv = new TemplateView((Object)this, name);
        tv.arg("categories", this.widgetTypesByCat);
        tv.arg("nuxeoVersions", this.getNuxeoVersions());
        tv.arg("widgetTypeCategory", (Object)this.category);
        tv.arg("widgetTypes", this.widgetTypes);
        tv.arg("studioCategories", (Object)StringUtils.join(this.getStudioCategories(), (String)" "));
        tv.arg("baseURL", (Object)baseURL);
        return tv;
    }

    @GET
    public Object doGet(@QueryParam(value="widgetType") String widgetTypeName, @Context UriInfo uriInfo) {
        if (widgetTypeName == null) {
            return this.getTemplate(uriInfo);
        }
        WidgetTypeDefinition wType = this.service.getWidgetTypeDefinition(this.category, widgetTypeName);
        if (wType == null) {
            throw new WebResourceNotFoundException("No widget type found with name: " + widgetTypeName);
        }
        TemplateView tpl = this.getTemplate(uriInfo);
        tpl.arg("widgetType", (Object)wType);
        return tpl;
    }

    public String getWidgetTypeLabel(WidgetTypeDefinition wTypeDef) {
        if (wTypeDef != null) {
            WidgetTypeConfiguration conf = wTypeDef.getConfiguration();
            if (conf != null) {
                return conf.getTitle();
            }
            return wTypeDef.getName();
        }
        return null;
    }

    public String getWidgetTypeDescription(WidgetTypeDefinition wTypeDef) {
        WidgetTypeConfiguration conf;
        if (wTypeDef != null && (conf = wTypeDef.getConfiguration()) != null) {
            return conf.getDescription();
        }
        return null;
    }

    public List<String> getWidgetTypeCategories(WidgetTypeDefinition wTypeDef) {
        WidgetTypeConfiguration conf;
        if (wTypeDef != null && (conf = wTypeDef.getConfiguration()) != null) {
            return conf.getCategories();
        }
        return null;
    }

    public String getWidgetTypeCategoriesAsString(WidgetTypeDefinition wTypeDef) {
        List<String> categories = this.getWidgetTypeCategories(wTypeDef);
        if (categories == null) {
            return "";
        }
        return StringUtils.join(categories, (String)", ");
    }
}

