/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.cache;

import java.util.HashMap;
import java.util.Map;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.cache.CacheAttributesChecker;
import org.nuxeo.ecm.core.cache.CacheInvalidator;
import org.nuxeo.ecm.core.cache.CacheManagement;
import org.nuxeo.ecm.core.cache.CacheMetrics;
import org.nuxeo.ecm.core.cache.CacheServiceImpl;
import org.nuxeo.ecm.core.cache.InMemoryCacheImpl;

@XObject(value="cache")
public class CacheDescriptor {
    public static final long DEFAULT_TTL = 1L;
    public static final long DEFAULT_MAX_SIZE = 100L;
    public static final String OPTION_MAX_SIZE = "maxSize";
    public static final String OPTION_CONCURRENCY_LEVEL = "concurrencyLevel";
    @XNode(value="@name")
    public String name;
    @XNode(value="@remove")
    public boolean remove;
    @XNode(value="@class")
    protected Class<? extends CacheManagement> klass;
    @XNode(value="ttl")
    public Long ttl;
    @XNodeMap(value="option", key="@name", type=HashMap.class, componentType=String.class)
    public Map<String, String> options = new HashMap<String, String>();

    public CacheDescriptor() {
    }

    public CacheDescriptor(CacheDescriptor other) {
        this.name = other.name;
        this.ttl = other.ttl;
        this.klass = other.klass;
        this.options = new HashMap<String, String>(other.options);
    }

    public CacheDescriptor clone() {
        return new CacheDescriptor(this);
    }

    public void merge(CacheDescriptor other) {
        this.remove = other.remove;
        if (other.ttl != null) {
            this.ttl = other.ttl;
        }
        if (other.klass != null) {
            this.klass = other.klass;
        }
        if (other.options != null) {
            if (this.options == null) {
                this.options = new HashMap<String, String>(other.options);
            } else {
                this.options.putAll(other.options);
            }
        }
    }

    public long getTTL() {
        return this.ttl == null ? 1L : this.ttl;
    }

    public String toString() {
        return this.name + ": " + this.klass + ": " + this.ttl + ": " + this.options;
    }

    protected CacheManagement newInstance(CacheServiceImpl.CachePubSubInvalidator invalidator) {
        CacheManagement cache;
        if (this.klass == null) {
            cache = new InMemoryCacheImpl(this);
        } else {
            try {
                cache = this.klass.getConstructor(CacheDescriptor.class).newInstance(this);
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException("Failed to instantiate class: " + this.klass + " for cache: " + this.name, (Throwable)e);
            }
        }
        cache = new CacheAttributesChecker(cache);
        cache = new CacheMetrics(cache);
        if (invalidator != null) {
            cache = new CacheInvalidator(cache, invalidator);
        }
        return cache;
    }
}

